/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.gamepad;

import com.studiohartman.jamepad.ControllerManager;
import de.mossgrabers.controller.gamepad.GamepadConfiguration;
import de.mossgrabers.controller.gamepad.controller.GamepadControlSurface;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.controller.AbstractControllerSetup;
import de.mossgrabers.framework.controller.ISetupFactory;
import de.mossgrabers.framework.controller.valuechanger.TwosComplementValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.ModelSetup;
import de.mossgrabers.framework.daw.midi.IMidiAccess;
import de.mossgrabers.framework.daw.midi.IMidiInput;

public class GamepadControllerSetup
extends AbstractControllerSetup<GamepadControlSurface, GamepadConfiguration> {
    private final ControllerManager gamepadManager = new ControllerManager();

    public GamepadControllerSetup(IHost host, ISetupFactory factory, ISettingsUI globalSettings, ISettingsUI documentSettings) {
        super(factory, host, globalSettings, documentSettings);
        this.gamepadManager.initSDLGamepad();
        this.valueChanger = new TwosComplementValueChanger(1024, 10);
        this.configuration = new GamepadConfiguration(host, this.valueChanger, factory.getArpeggiatorModes(), this.gamepadManager);
    }

    @Override
    protected void createScales() {
    }

    @Override
    protected void createModel() {
        ModelSetup ms = new ModelSetup();
        ms.enableMainDrumDevice(false);
        ms.setNumTracks(1);
        ms.setNumScenes(100);
        ms.setNumSends(0);
        ms.setNumDevicesInBank(0);
        ms.setNumDeviceLayers(0);
        ms.setNumParamPages(0);
        ms.setNumParams(0);
        ms.setNumDrumPadLayers(0);
        ms.setNumFilterColumnEntries(0);
        ms.setNumResults(0);
        this.model = this.factory.createModel(this.configuration, this.colorManager, this.valueChanger, this.scales, ms);
    }

    @Override
    protected void createSurface() {
        IMidiAccess midiAccess = this.factory.createMidiAccess();
        IMidiInput input = midiAccess.createInput("Gamepad", new String[0]);
        this.surfaces.add(new GamepadControlSurface(this.host, (GamepadConfiguration)this.configuration, this.colorManager, input, this.gamepadManager, this.model));
    }

    @Override
    protected void createObservers() {
        super.createObservers();
        ((GamepadConfiguration)this.configuration).addSettingObserver(GamepadConfiguration.SELECTED_GAMEPAD, () -> ((GamepadControlSurface)this.getSurface()).selectGamepad(((GamepadConfiguration)this.configuration).getSelectedGamepad()));
        this.createNoteRepeatObservers((GamepadConfiguration)this.configuration, (GamepadControlSurface)this.getSurface());
    }

    @Override
    public void startup() {
    }

    @Override
    public void exit() {
        super.exit();
        this.gamepadManager.quitSDLGamepad();
    }
}

