/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode.device;

import de.mossgrabers.controller.ableton.push.controller.Push1Display;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.BaseMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.daw.data.bank.IParameterPageBank;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.device.BankParameterProvider;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.Optional;

public class UserMode
extends BaseMode<IParameter> {
    private static final String[] TOP_MENU = new String[]{"Project", " ", " ", " ", " ", " ", " ", " "};
    private final BankParameterProvider projectParameterProvider;
    private final BankParameterProvider trackParameterProvider;
    private boolean isProjectMode = true;

    public UserMode(PushControlSurface surface, IModel model) {
        super("Project/Track Controls", surface, model, model.getProject().getParameterBank());
        this.projectParameterProvider = new BankParameterProvider(model.getProject().getParameterBank());
        this.trackParameterProvider = new BankParameterProvider(model.getCursorTrack().getParameterBank());
        this.setParameterProvider(this.projectParameterProvider);
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.setTouchedKnob(index, isTouched);
        IParameter param = (IParameter)this.bank.getItem(index);
        if (isTouched && ((PushControlSurface)this.surface).isDeletePressed()) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
            param.resetValue();
        }
        param.touchValue(isTouched);
        this.checkStopAutomationOnKnobRelease(isTouched);
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        IParameterPageBank parameterPageBank = ((IParameterBank)this.bank).getPageBank();
        if (!((String)parameterPageBank.getItem(index)).isBlank()) {
            parameterPageBank.selectPage(index);
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        int offColor = this.isPushModern ? 0 : 0;
        int index = this.isButtonRow(0, buttonID);
        if (index >= 0) {
            int selectedColor = this.isPushModern ? 9 : 10;
            int existsColor = this.isPushModern ? 15 : 13;
            IParameterPageBank parameterPageBank = ((IParameterBank)this.bank).getPageBank();
            if (((String)parameterPageBank.getItem(index)).isBlank()) {
                return offColor;
            }
            int selectedPage = parameterPageBank.getSelectedItemIndex();
            return index == selectedPage ? selectedColor : existsColor;
        }
        index = this.isButtonRow(1, buttonID);
        if (index >= 0) {
            if (index > 1) {
                return offColor;
            }
            int selectedColor = this.isPushModern ? 3 : 3;
            int existsColor = this.isPushModern ? 1 : 1;
            return index == 0 && this.isProjectMode || index == 1 && !this.isProjectMode ? selectedColor : existsColor;
        }
        return super.getButtonColor(buttonID);
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event == ButtonEvent.UP && index <= 1) {
            this.setMode(index == 0);
        }
    }

    private void setMode(boolean isProjectMode) {
        this.isProjectMode = isProjectMode;
        this.switchBanks(this.isProjectMode ? this.model.getProject().getParameterBank() : this.model.getCursorTrack().getParameterBank());
        this.setParameterProvider(this.isProjectMode ? this.projectParameterProvider : this.trackParameterProvider);
        this.bindControls();
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        IParameterPageBank parameterPageBank = ((IParameterBank)this.bank).getPageBank();
        Optional selectedTrack = this.model.getCurrentTrackBank().getSelectedItem();
        String trackHeader = selectedTrack.isEmpty() ? "None" : ((ITrack)selectedTrack.get()).getName();
        for (int i = 0; i < this.bank.getPageSize(); ++i) {
            IParameter param = (IParameter)this.bank.getItem(i);
            display.setCell(0, i, param.doesExist() ? StringUtils.fixASCII(param.getName()) : "").setCell(1, i, param.getDisplayedValue(8));
        }
        display.setBlock(2, 0, this.isProjectMode ? "Params : Project" : "Params : Track ->");
        if (!this.isProjectMode) {
            display.setBlock(2, 1, trackHeader);
        }
        int selectedPage = parameterPageBank.getSelectedItemIndex();
        for (int i = 0; i < parameterPageBank.getPageSize(); ++i) {
            String pageName = (String)parameterPageBank.getItem(i);
            if (pageName.isBlank()) continue;
            display.setCell(3, i, (i == selectedPage ? Push1Display.SELECT_ARROW : "") + pageName);
        }
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        IParameterPageBank parameterPageBank = ((IParameterBank)this.bank).getPageBank();
        IValueChanger valueChanger = this.model.getValueChanger();
        int selectedPage = parameterPageBank.getSelectedItemIndex();
        Optional selectedTrack = this.model.getCurrentTrackBank().getSelectedItem();
        String trackHeader = selectedTrack.isEmpty() ? "None" : ((ITrack)selectedTrack.get()).getName();
        ColorEx trackColor = selectedTrack.isEmpty() ? ColorEx.BLACK : ((ITrack)selectedTrack.get()).getColor();
        for (int i = 0; i < this.bank.getPageSize(); ++i) {
            boolean isTopMenuSelected;
            boolean isBottomMenuOn = i == selectedPage;
            IParameter param = (IParameter)this.bank.getItem(i);
            boolean exists = param.doesExist();
            String parameterName = exists ? param.getName(9) : "";
            int parameterValue = valueChanger.toDisplayValue(exists ? param.getValue() : 0);
            String parameterValueStr = exists ? param.getDisplayedValue(8) : "";
            boolean parameterIsActive = this.isKnobTouched(i);
            int parameterModulatedValue = valueChanger.toDisplayValue(exists ? param.getModulatedValue() : -1);
            String bottomMenu = StringUtils.limit((String)parameterPageBank.getItem(i), 12);
            String bottomMenuIcon = this.isProjectMode ? "PROJECT" : "TRACK";
            boolean bl = isTopMenuSelected = i == 0 && this.isProjectMode || i == 1 && !this.isProjectMode;
            ColorEx bottomMenuColor = this.isProjectMode ? (isBottomMenuOn ? ColorEx.WHITE : ColorEx.GRAY) : trackColor;
            display.addParameterElement(i == 1 ? trackHeader : TOP_MENU[i], isTopMenuSelected, bottomMenu, bottomMenuIcon, bottomMenuColor, isBottomMenuOn, parameterName, parameterValue, parameterValueStr, parameterIsActive, parameterModulatedValue);
        }
    }
}

