/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.device;

import de.mossgrabers.framework.utils.Pair;
import de.mossgrabers.reaper.framework.device.DeviceFileType;
import de.mossgrabers.reaper.framework.device.DeviceMetadataImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DeviceCollection {
    private static final int TYPE_JS = 2;
    private static final int TYPE_VST = 3;
    private static final int TYPE_QUERY = 0x100000;
    private static final char[] MODULE_CHARS_TO_REPLACE = new char[]{' ', '(', ')', '-', '+'};
    private final String name;
    private final Set<String> jsItems = new HashSet<String>();
    private final Set<String> vstItems = new HashSet<String>();
    private final Map<String, Pair<Set<String>, Set<String>>> queryItems = new HashMap<String, Pair<Set<String>, Set<String>>>();

    public DeviceCollection(String name) {
        this.name = name;
    }

    public void addItem(String item, int type) {
        switch (type) {
            case 2: {
                this.jsItems.add(item.startsWith("\"") && item.endsWith("\"") ? item.substring(1, item.length() - 2) : item);
                break;
            }
            case 3: {
                String[] split = item.split("[\\\\/]");
                if (split == null || split.length <= 0) break;
                this.vstItems.add(DeviceCollection.cleanupFilename(split[split.length - 1]));
                break;
            }
            case 0x100000: {
                HashSet<String> mustMatch = new HashSet<String>();
                HashSet<String> mustNotMatch = new HashSet<String>();
                for (String part : item.split(" OR ")) {
                    String[] notParts = part.split(" NOT ");
                    mustMatch.add(notParts[0].trim().toLowerCase(Locale.US));
                    for (int i = 1; i < notParts.length; ++i) {
                        String notStr = notParts[i].trim().toLowerCase(Locale.US);
                        int length = notStr.length();
                        if (length > 2 && notStr.charAt(0) == '(' && notStr.charAt(length - 1) == ')') {
                            notStr = notStr.substring(1, length - 2).trim();
                        }
                        mustNotMatch.add(notStr);
                    }
                }
                this.queryItems.put(item, new Pair(mustMatch, mustNotMatch));
                break;
            }
        }
    }

    private static String cleanupFilename(String filename) {
        String fn = filename;
        for (char c : MODULE_CHARS_TO_REPLACE) {
            fn = fn.replace(c, '_');
        }
        return fn.toLowerCase(Locale.US);
    }

    public String getName() {
        return this.name;
    }

    public List<DeviceMetadataImpl> filter(List<DeviceMetadataImpl> devices) {
        ArrayList<DeviceMetadataImpl> results = new ArrayList<DeviceMetadataImpl>();
        for (DeviceMetadataImpl d : devices) {
            if (!this.testDevice(d)) continue;
            results.add(d);
        }
        return results;
    }

    private boolean testDevice(DeviceMetadataImpl device) {
        boolean isJS = device.getFileType().equals((Object)DeviceFileType.JS);
        String module = device.getModule();
        if (isJS ? this.jsItems.contains(module.startsWith("\"") && module.endsWith("\"") ? module.substring(1, module.length() - 1) : module) : this.vstItems.contains(module)) {
            return true;
        }
        for (Pair<Set<String>, Set<String>> query : this.queryItems.values()) {
            if (!DeviceCollection.compareQuery(query.getKey(), query.getValue(), device)) continue;
            return true;
        }
        return false;
    }

    private static boolean compareQuery(Set<String> mustMatch, Set<String> mustNotMatch, DeviceMetadataImpl device) {
        String text = (device.name() + " " + device.getVendor() + " " + String.valueOf((Object)device.getFileType())).toLowerCase(Locale.US);
        boolean success = mustMatch.isEmpty();
        for (String match : mustMatch) {
            if (!text.contains(match)) continue;
            success = true;
            break;
        }
        if (!success) {
            return false;
        }
        for (String notMatch : mustNotMatch) {
            if (!text.contains(notMatch)) continue;
            return false;
        }
        return true;
    }
}

