/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data;

import de.mossgrabers.framework.daw.data.EqualizerBandType;
import de.mossgrabers.framework.daw.data.IEqualizerDevice;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import de.mossgrabers.reaper.framework.daw.data.SpecificDeviceImpl;
import de.mossgrabers.reaper.framework.daw.data.parameter.EqBandTypeParameterImpl;

public class EqualizerDeviceImpl
extends SpecificDeviceImpl
implements IEqualizerDevice {
    private static final int NUMBER_OF_BANDS = 8;
    private final EqBandTypeParameterImpl[] eqBandTypeParameters = new EqBandTypeParameterImpl[8];

    public EqualizerDeviceImpl(DataSetupEx dataSetup, int numParams) {
        super(dataSetup, Processor.EQ, 0, numParams, 0, 0, 0, 0);
        for (int i = 0; i < this.eqBandTypeParameters.length; ++i) {
            this.eqBandTypeParameters[i] = new EqBandTypeParameterImpl(dataSetup, i);
        }
    }

    @Override
    public int getBandCount() {
        return 8;
    }

    @Override
    public EqualizerBandType getTypeID(int index) {
        return this.doesExist() ? this.eqBandTypeParameters[index].getTypeInternal() : EqualizerBandType.OFF;
    }

    @Override
    public void setType(int index, EqualizerBandType type) {
        this.eqBandTypeParameters[index].setType(type);
    }

    public void setTypeInternal(int index, int typeIndex) {
        this.eqBandTypeParameters[index].setTypeInternal(typeIndex);
    }

    @Override
    public IParameter getTypeParameter(int index) {
        return this.eqBandTypeParameters[index];
    }

    @Override
    public IParameter getFrequencyParameter(int index) {
        return (IParameter)this.getParameterBank().getItem(3 * index);
    }

    @Override
    public IParameter getGainParameter(int index) {
        return (IParameter)this.getParameterBank().getItem(3 * index + 1);
    }

    @Override
    public IParameter getQParameter(int index) {
        return (IParameter)this.getParameterBank().getItem(3 * index + 2);
    }

    @Override
    protected Processor getProcessor() {
        return Processor.EQ;
    }
}

