/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.mode;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.utils.ButtonEvent;

public class ButtonRowModeCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    private final int index;
    private final int row;
    private final ModeManager modeManager;

    public ButtonRowModeCommand(int row, int index, IModel model, S surface) {
        this(surface.getModeManager(), row, index, model, surface);
    }

    public ButtonRowModeCommand(ModeManager modeManager, int row, int index, IModel model, S surface) {
        super(model, surface);
        this.row = row;
        this.index = index;
        this.modeManager = modeManager;
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        IMode m = (IMode)this.modeManager.getActive();
        if (m != null) {
            m.onButton(this.row, this.index, event);
        }
    }
}

