/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.view;

import de.mossgrabers.controller.novation.launchpad.LaunchpadConfiguration;
import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.featuregroup.IScrollableView;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.utils.ScrollStates;
import de.mossgrabers.framework.view.sequencer.AbstractRaindropsView;
import de.mossgrabers.framework.view.sequencer.AbstractSequencerView;

public class RaindropsView
extends AbstractRaindropsView<LaunchpadControlSurface, LaunchpadConfiguration>
implements IScrollableView {
    public RaindropsView(LaunchpadControlSurface surface, IModel model) {
        super("Raindrops", surface, model, true);
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        if (!this.isActive()) {
            return 0;
        }
        int ordinal = buttonID.ordinal();
        if (ordinal < ButtonID.SCENE1.ordinal() || ordinal > ButtonID.SCENE8.ordinal()) {
            return 0;
        }
        int scene = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        return scene == 7 - this.getResolutionIndex() ? 14 : 22;
    }

    @Override
    public void updateScrollStates(ScrollStates scrollStates) {
        ViewManager viewManager = ((LaunchpadControlSurface)this.surface).getViewManager();
        INoteClip clip = ((AbstractSequencerView)AbstractSequencerView.class.cast(viewManager.getActive())).getClip();
        int seqOctave = this.scales.getOctave();
        scrollStates.setCanScrollLeft(clip.canScrollStepsBackwards());
        scrollStates.setCanScrollRight(clip.canScrollStepsForwards());
        scrollStates.setCanScrollUp(seqOctave < 4);
        scrollStates.setCanScrollDown(seqOctave > -4);
    }
}

