/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchkey.maxi.view;

import de.mossgrabers.controller.novation.launchkey.maxi.LaunchkeyMk3Configuration;
import de.mossgrabers.controller.novation.launchkey.maxi.controller.LaunchkeyMk3ControlSurface;
import de.mossgrabers.controller.novation.launchkey.maxi.controller.LaunchkeyPadGrid;
import de.mossgrabers.controller.novation.launchkey.maxi.view.SessionView;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.IDisplay;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IScene;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.featuregroup.AbstractView;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;

public class PadModeSelectView
extends AbstractView<LaunchkeyMk3ControlSurface, LaunchkeyMk3Configuration> {
    private static final String[] PAD_MODE_NAMES = new String[]{"Clips", "Record Arm", "Track Select", "Mute", "Solo", "Stop Clips"};
    private boolean isConsumed = false;

    public PadModeSelectView(LaunchkeyMk3ControlSurface surface, IModel model) {
        super("Pad Mode Select", surface, model);
    }

    @Override
    public void drawGrid() {
        LaunchkeyPadGrid pads = ((LaunchkeyMk3ControlSurface)this.surface).getPadGrid();
        LaunchkeyMk3Configuration configuration = (LaunchkeyMk3Configuration)((LaunchkeyMk3ControlSurface)this.surface).getConfiguration();
        int clipLengthIndex = configuration.getNewClipLength();
        for (int x = 0; x < 8; ++x) {
            pads.lightEx(x, 0, DAWColor.getColorID((x == clipLengthIndex ? DAWColor.DAW_COLOR_RED : DAWColor.DAW_COLOR_LIGHT_ORANGE).getColor()));
        }
        SessionView view = (SessionView)((LaunchkeyMk3ControlSurface)this.surface).getViewManager().get(Views.SESSION);
        Modes padMode = view.getPadMode();
        pads.lightEx(0, 1, padMode == null ? 21 : 23);
        pads.lightEx(1, 1, padMode == Modes.REC_ARM ? 5 : 7);
        pads.lightEx(2, 1, padMode == Modes.TRACK_SELECT ? 3 : 1);
        pads.lightEx(3, 1, padMode == Modes.MUTE ? 9 : 11);
        pads.lightEx(4, 1, padMode == Modes.SOLO ? 13 : 15);
        pads.lightEx(5, 1, padMode == Modes.STOP_CLIP ? 57 : 4);
        pads.lightEx(6, 1, 0);
        pads.lightEx(7, 1, 0);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity == 0) {
            return;
        }
        int index = note - 36;
        if (index > 5 && index < 8) {
            return;
        }
        IDisplay display = ((LaunchkeyMk3ControlSurface)this.surface).getDisplay();
        if (index <= 5) {
            SessionView view = (SessionView)((LaunchkeyMk3ControlSurface)this.surface).getViewManager().get(Views.SESSION);
            view.setPadMode(index == 0 ? null : SessionView.PAD_MODES.get(index - 1));
            display.notify(PAD_MODE_NAMES[index]);
        } else {
            int newClipLength = index - 8;
            ((LaunchkeyMk3Configuration)((LaunchkeyMk3ControlSurface)this.surface).getConfiguration()).setNewClipLength(newClipLength);
            display.notify("New Clip Length:" + AbstractConfiguration.getNewClipLengthValue(newClipLength));
        }
        this.isConsumed = true;
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (!ButtonID.isSceneButton(buttonID)) {
            return;
        }
        if (event == ButtonEvent.LONG) {
            this.isConsumed = true;
            return;
        }
        if (event == ButtonEvent.DOWN) {
            return;
        }
        ((LaunchkeyMk3ControlSurface)this.surface).getViewManager().restore();
        if (this.isConsumed) {
            return;
        }
        ISceneBank sceneBank = this.model.getCurrentTrackBank().getSceneBank();
        int index = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        IScene scene = (IScene)sceneBank.getItem(index);
        scene.select();
        scene.launch(true, false);
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        if (buttonID == ButtonID.SCENE2) {
            return 3;
        }
        return 0;
    }

    @Override
    public void onActivate() {
        this.isConsumed = false;
    }
}

