/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3.command.trigger;

import de.mossgrabers.controller.ni.maschine.mk3.MaschineConfiguration;
import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.controller.ni.maschine.mk3.view.PlayView;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.mode.INoteEditorMode;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;

public class KeyboardCommand
extends AbstractTriggerCommand<MaschineControlSurface, MaschineConfiguration> {
    public KeyboardCommand(IModel model, MaschineControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ViewManager viewManager = ((MaschineControlSurface)this.surface).getViewManager();
        if (viewManager.isActive(new Views[]{Views.PLAY})) {
            if (!((MaschineControlSurface)this.surface).getMaschine().hasMCUDisplay()) {
                ((PlayView)viewManager.get(Views.PLAY)).toggleShifted();
            }
            ModeManager modeManager = ((MaschineControlSurface)this.surface).getModeManager();
            if (modeManager.isActive(new Modes[]{Modes.SCALES})) {
                modeManager.restore();
            } else {
                modeManager.setTemporary(Modes.SCALES);
            }
        } else {
            viewManager.setActive(Views.PLAY);
            ((INoteEditorMode)((MaschineControlSurface)this.surface).getModeManager().get(Modes.NOTE)).getNoteEditor().clearNotes();
            ICursorTrack cursorTrack = this.model.getCursorTrack();
            if (cursorTrack.doesExist()) {
                viewManager.setPreferredView(cursorTrack.getPosition(), Views.PLAY);
            }
        }
    }
}

