/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.jam.mode;

import de.mossgrabers.controller.ni.maschine.jam.MaschineJamConfiguration;
import de.mossgrabers.controller.ni.maschine.jam.controller.FaderConfig;
import de.mossgrabers.controller.ni.maschine.jam.controller.MaschineJamControlSurface;
import de.mossgrabers.controller.ni.maschine.jam.mode.FaderSlowChange;
import de.mossgrabers.controller.ni.maschine.jam.mode.IMaschineJamMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.mode.device.ProjectParamsMode;
import de.mossgrabers.framework.parameter.IParameter;

public class MaschineJamUserMode
extends ProjectParamsMode<MaschineJamControlSurface, MaschineJamConfiguration>
implements IMaschineJamMode {
    private static final FaderConfig FADER_OFF = new FaderConfig(0, 0, 0);
    private FaderSlowChange slowChange = new FaderSlowChange();

    public MaschineJamUserMode(MaschineJamControlSurface surface, IModel model) {
        super(surface, model, true, null);
    }

    @Override
    public void onKnobValue(int index, int value) {
        IParameterBank bank = this.isProjectMode ? this.model.getProject().getParameterBank() : this.model.getCursorTrack().getParameterBank();
        IParameter item = (IParameter)bank.getItem(index);
        if (item != null && item.doesExist()) {
            this.slowChange.changeValue((MaschineJamControlSurface)this.surface, item, value);
        }
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.setTouchedKnob(index, isTouched);
        IParameter param = (IParameter)this.bank.getItem(index);
        if (!param.doesExist()) {
            return;
        }
        if (isTouched && ((MaschineJamControlSurface)this.surface).isDeletePressed()) {
            ((MaschineJamControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
            param.resetValue();
        }
        param.touchValue(isTouched);
    }

    @Override
    public void selectPreviousItemPage() {
        super.selectPreviousItem();
        if (this.isProjectMode) {
            this.mvHelper.notifySelectedProjectParameterPage();
        } else {
            this.mvHelper.notifySelectedTrackParameterPage();
        }
    }

    @Override
    public void selectNextItemPage() {
        super.selectNextItem();
        if (this.isProjectMode) {
            this.mvHelper.notifySelectedProjectParameterPage();
        } else {
            this.mvHelper.notifySelectedTrackParameterPage();
        }
    }

    @Override
    public FaderConfig setupFader(int index) {
        IParameter parameter = (IParameter)this.bank.getItem(index);
        if (!parameter.doesExist()) {
            return FADER_OFF;
        }
        int value = this.model.getValueChanger().toMidiValue(parameter.getValue());
        return new FaderConfig(0, this.isProjectMode ? 78 : 14, value);
    }
}

