/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.jam.mode;

import de.mossgrabers.controller.ni.maschine.core.MaschineColorManager;
import de.mossgrabers.controller.ni.maschine.jam.MaschineJamConfiguration;
import de.mossgrabers.controller.ni.maschine.jam.controller.FaderConfig;
import de.mossgrabers.controller.ni.maschine.jam.controller.MaschineJamControlSurface;
import de.mossgrabers.controller.ni.maschine.jam.mode.FaderSlowChange;
import de.mossgrabers.controller.ni.maschine.jam.mode.IMaschineJamMode;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.mode.device.ParameterMode;
import de.mossgrabers.framework.parameter.IParameter;

public class MaschineJamParameterMode
extends ParameterMode<MaschineJamControlSurface, MaschineJamConfiguration>
implements IMaschineJamMode {
    private static final FaderConfig FADER_OFF = new FaderConfig(0, 0, 0);
    private FaderSlowChange slowChange = new FaderSlowChange();

    public MaschineJamParameterMode(MaschineJamControlSurface surface, IModel model) {
        super(surface, model, true);
    }

    @Override
    public void onKnobValue(int index, int value) {
        if (!this.cursorDevice.doesExist()) {
            return;
        }
        IParameter item = (IParameter)this.cursorDevice.getParameterBank().getItem(index);
        if (item != null && item.doesExist()) {
            this.slowChange.changeValue((MaschineJamControlSurface)this.surface, item, value);
        }
    }

    @Override
    public void selectPreviousItemPage() {
        if (((MaschineJamControlSurface)this.surface).isSelectPressed()) {
            this.cursorDevice.selectPrevious();
        } else {
            this.cursorDevice.getParameterBank().scrollBackwards();
        }
        this.mvHelper.notifySelectedDeviceAndParameterPage();
    }

    @Override
    public void selectNextItemPage() {
        if (((MaschineJamControlSurface)this.surface).isSelectPressed()) {
            this.cursorDevice.selectNext();
        } else {
            this.cursorDevice.getParameterBank().scrollForwards();
        }
        this.mvHelper.notifySelectedDeviceAndParameterPage();
    }

    @Override
    public FaderConfig setupFader(int index) {
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        if (!cursorDevice.doesExist()) {
            return FADER_OFF;
        }
        IParameter parameter = (IParameter)cursorDevice.getParameterBank().getItem(index);
        if (!parameter.doesExist()) {
            return FADER_OFF;
        }
        int value = this.model.getValueChanger().toMidiValue(parameter.getValue());
        return new FaderConfig(0, MaschineColorManager.PARAM_COLORS.get(index), value);
    }
}

