/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.mcu.command.trigger;

import de.mossgrabers.controller.mackie.mcu.MCUConfiguration;
import de.mossgrabers.controller.mackie.mcu.controller.MCUControlSurface;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.DeviceID;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.ILayer;
import de.mossgrabers.framework.daw.data.IMarker;
import de.mossgrabers.framework.daw.data.ISpecificDevice;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.EnumMap;
import java.util.Map;

public class SelectCommand
extends AbstractTriggerCommand<MCUControlSurface, MCUConfiguration> {
    private static final Map<Modes, Modes> TRACK_LAYER_MODE_MAP = new EnumMap<Modes, Modes>(Modes.class);
    private static final Map<Modes, Modes> LAYER_TRACK_MODE_MAP = new EnumMap<Modes, Modes>(Modes.class);
    private final boolean useFxBank;
    protected final int index;
    protected final int channel;

    public SelectCommand(int index, IModel model, MCUControlSurface surface) {
        super(model, surface);
        MCUConfiguration configuration = (MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration();
        this.useFxBank = configuration.shouldPinFXTracksToLastController() && ((MCUControlSurface)this.surface).getSurfaceID() == configuration.getNumMCUDevices() - 1;
        this.index = index;
        this.channel = this.useFxBank ? this.index : ((MCUControlSurface)this.surface).getExtenderOffset() + this.index;
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (this.handleButtonCombinations(event)) {
            return;
        }
        if (event == ButtonEvent.UP) {
            this.handleSelectEnter();
        } else if (event == ButtonEvent.LONG) {
            this.handleLeave();
        }
    }

    private void handleSelectEnter() {
        Modes layerMode;
        ModeManager modeManager = ((MCUControlSurface)this.surface).getModeManager();
        ISpecificDevice firstDevice = this.model.getSpecificDevice(DeviceID.FIRST_INSTRUMENT);
        if (Modes.isLayerMode((Modes)((Object)modeManager.getActiveID()))) {
            ILayer layer = (ILayer)firstDevice.getLayerBank().getItem(this.channel);
            if (!layer.isSelected()) {
                layer.select();
            }
            return;
        }
        ITrackBank trackBank = this.getTrackBank();
        ITrack track = (ITrack)trackBank.getItem(this.channel);
        if (!track.isSelected()) {
            track.select();
            return;
        }
        if (track.isGroup()) {
            if (((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).isTrackNavigationFlat()) {
                track.toggleGroupExpanded();
            } else {
                track.setGroupExpanded(true);
                track.enter();
            }
            return;
        }
        if (firstDevice.hasLayers() && (layerMode = TRACK_LAYER_MODE_MAP.get(modeManager.getActiveID())) != null) {
            modeManager.setActive(layerMode);
        }
    }

    private void handleLeave() {
        ModeManager modeManager = ((MCUControlSurface)this.surface).getModeManager();
        if (Modes.isLayerMode((Modes)((Object)modeManager.getActiveID()))) {
            Modes trackMode = LAYER_TRACK_MODE_MAP.get(modeManager.getActiveID());
            if (trackMode != null) {
                modeManager.setActive(trackMode);
            }
        } else if (!((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).isTrackNavigationFlat()) {
            this.getTrackBank().selectParent();
        }
        for (int i = 0; i < 8; ++i) {
            ((MCUControlSurface)this.surface).setTriggerConsumed(ButtonID.get(ButtonID.ROW_SELECT_1, i));
        }
    }

    private boolean handleButtonCombinations(ButtonEvent event) {
        if (((MCUControlSurface)this.surface).isPressed(ButtonID.SENDS)) {
            if (event == ButtonEvent.DOWN) {
                this.handleSendSelection();
            }
            return true;
        }
        if (((MCUControlSurface)this.surface).isSelectPressed()) {
            if (event == ButtonEvent.DOWN) {
                ((ITrack)this.getTrackBank().getItem(this.channel)).stop(false);
            }
            return true;
        }
        if (((MCUControlSurface)this.surface).isPressed(ButtonID.CONTROL)) {
            ITrack track;
            if (event == ButtonEvent.DOWN && (track = (ITrack)this.getTrackBank().getItem(this.channel)).isGroup()) {
                track.toggleGroupExpanded();
            }
            return true;
        }
        if (((MCUControlSurface)this.surface).isPressed(ButtonID.ALT)) {
            ((MCUControlSurface)this.surface).getDisplay().notify(AbstractConfiguration.getNewClipLengthValue(this.index));
            ((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).setNewClipLength(this.index);
            return true;
        }
        if (((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).hasOnly1Fader()) {
            if (event != ButtonEvent.DOWN) {
                return true;
            }
            ModeManager modeManager = ((MCUControlSurface)this.surface).getModeManager();
            if (modeManager.isActive(new Modes[]{Modes.MARKERS})) {
                ((IMarker)this.model.getMarkerBank().getItem(this.channel)).select();
                return true;
            }
            if (modeManager.isActive(new Modes[]{Modes.DEVICE_PARAMS})) {
                ICursorDevice cursorDevice = this.model.getCursorDevice();
                if (cursorDevice.doesExist()) {
                    ((IParameter)cursorDevice.getParameterBank().getItem(this.channel)).select();
                }
                return true;
            }
        }
        return false;
    }

    private void handleSendSelection() {
        ITextDisplay display = ((MCUControlSurface)this.surface).getTextDisplay();
        ITrackBank effectTrackBank = this.model.getEffectTrackBank();
        if (effectTrackBank != null && ((ITrack)effectTrackBank.getItem(this.channel)).doesExist()) {
            ModeManager modeManager;
            boolean isLayerMode = Modes.isLayerMode((Modes)((Object)(modeManager = ((MCUControlSurface)this.surface).getModeManager()).getActiveID()));
            modeManager.setActive(Modes.get(isLayerMode ? Modes.DEVICE_LAYER_SEND1 : Modes.SEND1, this.index));
            display.notify("Send channel " + (this.channel + 1) + " selected.");
        } else {
            display.notify("Send channel " + (this.channel + 1) + " does not exist.");
        }
        ((MCUControlSurface)this.surface).setTriggerConsumed(ButtonID.SENDS);
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event != ButtonEvent.DOWN || this.index >= 8) {
            return;
        }
        ((ITrack)this.getTrackBank().getItem(this.channel)).toggleMultiSelect();
    }

    protected ITrackBank getTrackBank() {
        ITrackBank effectTrackBank;
        if (this.useFxBank && (effectTrackBank = this.model.getEffectTrackBank()) != null) {
            return effectTrackBank;
        }
        return this.model.getCurrentTrackBank();
    }

    static {
        TRACK_LAYER_MODE_MAP.put(Modes.TRACK, Modes.DEVICE_LAYER);
        TRACK_LAYER_MODE_MAP.put(Modes.VOLUME, Modes.DEVICE_LAYER_VOLUME);
        TRACK_LAYER_MODE_MAP.put(Modes.PAN, Modes.DEVICE_LAYER_PAN);
        TRACK_LAYER_MODE_MAP.put(Modes.SEND1, Modes.DEVICE_LAYER_SEND1);
        TRACK_LAYER_MODE_MAP.put(Modes.SEND2, Modes.DEVICE_LAYER_SEND2);
        TRACK_LAYER_MODE_MAP.put(Modes.SEND3, Modes.DEVICE_LAYER_SEND3);
        TRACK_LAYER_MODE_MAP.put(Modes.SEND4, Modes.DEVICE_LAYER_SEND4);
        TRACK_LAYER_MODE_MAP.put(Modes.SEND5, Modes.DEVICE_LAYER_SEND5);
        TRACK_LAYER_MODE_MAP.put(Modes.SEND6, Modes.DEVICE_LAYER_SEND6);
        TRACK_LAYER_MODE_MAP.put(Modes.SEND7, Modes.DEVICE_LAYER_SEND7);
        TRACK_LAYER_MODE_MAP.put(Modes.SEND8, Modes.DEVICE_LAYER_SEND8);
        LAYER_TRACK_MODE_MAP.put(Modes.DEVICE_LAYER, Modes.TRACK);
        LAYER_TRACK_MODE_MAP.put(Modes.DEVICE_LAYER_VOLUME, Modes.VOLUME);
        LAYER_TRACK_MODE_MAP.put(Modes.DEVICE_LAYER_PAN, Modes.PAN);
        LAYER_TRACK_MODE_MAP.put(Modes.DEVICE_LAYER_SEND1, Modes.SEND1);
        LAYER_TRACK_MODE_MAP.put(Modes.DEVICE_LAYER_SEND2, Modes.SEND2);
        LAYER_TRACK_MODE_MAP.put(Modes.DEVICE_LAYER_SEND3, Modes.SEND3);
        LAYER_TRACK_MODE_MAP.put(Modes.DEVICE_LAYER_SEND4, Modes.SEND4);
        LAYER_TRACK_MODE_MAP.put(Modes.DEVICE_LAYER_SEND5, Modes.SEND5);
        LAYER_TRACK_MODE_MAP.put(Modes.DEVICE_LAYER_SEND6, Modes.SEND6);
        LAYER_TRACK_MODE_MAP.put(Modes.DEVICE_LAYER_SEND7, Modes.SEND7);
        LAYER_TRACK_MODE_MAP.put(Modes.DEVICE_LAYER_SEND8, Modes.SEND8);
    }
}

