/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.command.trigger;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.framework.command.continuous.PlayPositionCommand;
import de.mossgrabers.framework.command.core.TriggerCommand;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;

public class PlayPositionKnobCommand
extends PlayPositionCommand<PushControlSurface, PushConfiguration>
implements TriggerCommand {
    public PlayPositionKnobCommand(IModel model, PushControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void execute(int value) {
        if (((PushControlSurface)this.surface).isSelectPressed()) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.SELECT);
            this.transport.changeLoopLength(this.model.getValueChanger().isIncrease(value), ((PushControlSurface)this.surface).isKnobSensitivitySlow());
            return;
        }
        super.execute(value);
        this.displayPosition();
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        boolean activate;
        boolean bl = activate = event != ButtonEvent.UP;
        if (((PushControlSurface)this.surface).isSelectPressed()) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.SELECT);
            if (activate) {
                this.mvHelper.delayDisplay(() -> "Loop Length: " + this.transport.getLoopLengthBeatText());
            }
            return;
        }
        this.transport.setTempoIndication(activate);
        if (activate) {
            this.displayPosition();
        }
    }

    protected void displayPosition() {
        this.mvHelper.delayDisplay(() -> this.transport.getBeatText() + " - " + this.transport.getPositionText());
    }
}

