/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.device.column;

import de.mossgrabers.reaper.framework.device.DeviceManager;
import de.mossgrabers.reaper.framework.device.column.BaseColumn;
import de.mossgrabers.reaper.framework.device.column.BaseColumnItem;
import java.util.List;

public class DeviceCategoryFilterColumn
extends BaseColumn {
    public DeviceCategoryFilterColumn(int columnIndex, int numFilterColumnEntries) {
        super(columnIndex, "Category", numFilterColumnEntries);
        for (int i = 0; i < numFilterColumnEntries; ++i) {
            this.items[i] = new DeviceCategoryBrowserColumnItem(i);
        }
    }

    @Override
    public List<String> getAllItems() {
        return DeviceManager.get().getCategories();
    }

    private class DeviceCategoryBrowserColumnItem
    extends BaseColumnItem {
        public DeviceCategoryBrowserColumnItem(int index) {
            super(index);
        }

        @Override
        public int getIndex() {
            return DeviceCategoryFilterColumn.this.calcPosition(this.index);
        }

        @Override
        public boolean isSelected() {
            return this.getIndex() == DeviceCategoryFilterColumn.this.selectedRow;
        }

        @Override
        protected String getCachedName() {
            if (this.position == 0) {
                return "All";
            }
            int pos = this.position - 1;
            return pos < DeviceCategoryFilterColumn.this.getMaxNumItems() ? DeviceCategoryFilterColumn.this.getAllItems().get(pos) : "";
        }

        @Override
        protected int getCachedHitCount() {
            DeviceManager deviceManager = DeviceManager.get();
            if (this.position == 0) {
                return deviceManager.getNumDevices();
            }
            int pos = this.position - 1;
            return pos < DeviceCategoryFilterColumn.this.getMaxNumItems() ? deviceManager.filterByCategory(DeviceCategoryFilterColumn.this.getAllItems().get(pos)).size() : 0;
        }
    }
}

