/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data.bank;

import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISlotBank;
import de.mossgrabers.framework.daw.data.empty.EmptySlot;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import de.mossgrabers.reaper.framework.daw.data.SlotImpl;
import de.mossgrabers.reaper.framework.daw.data.TrackImpl;
import de.mossgrabers.reaper.framework.daw.data.bank.AbstractPagedBankImpl;
import de.mossgrabers.reaper.framework.daw.data.bank.SceneBankImpl;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class SlotBankImpl
extends AbstractPagedBankImpl<SlotImpl, ISlot>
implements ISlotBank {
    private final SceneBankImpl sceneBank;
    private final ITrack track;

    public SlotBankImpl(DataSetupEx dataSetup, SceneBankImpl sceneBank, TrackImpl track, int numSlots) {
        super(dataSetup, numSlots, EmptySlot.INSTANCE);
        this.sceneBank = sceneBank;
        this.track = track;
    }

    protected SlotBankImpl(SlotBankImpl slotBankImpl, int numSlots) {
        super(slotBankImpl.dataSetup, numSlots, EmptySlot.INSTANCE, slotBankImpl.items);
        this.sceneBank = slotBankImpl.sceneBank;
        this.track = slotBankImpl.track;
    }

    @Override
    protected SlotImpl createItem(int position) {
        return new SlotImpl(this.dataSetup, this.track, this.pageSize == 0 ? 0 : position % this.pageSize, this.sceneBank);
    }

    @Override
    public Optional<ISlot> getSelectedItem() {
        if (this.items.isEmpty()) {
            return Optional.empty();
        }
        for (int i = 0; i < this.getPageSize(); ++i) {
            ISlot slot = (ISlot)this.getItem(i);
            if (!slot.isSelected()) continue;
            return Optional.of(slot);
        }
        return Optional.empty();
    }

    @Override
    public List<ISlot> getSelectedItems() {
        Optional<ISlot> selectedItem = this.getSelectedItem();
        return selectedItem.isEmpty() ? Collections.emptyList() : Collections.singletonList(selectedItem.get());
    }

    @Override
    public Optional<ISlot> getEmptySlot(int startFrom) {
        return Optional.of(new SlotImpl(this.dataSetup, this.track, startFrom, this.sceneBank));
    }

    @Override
    public void selectPreviousPage() {
        if (this.pageSize == 0) {
            return;
        }
        this.sceneBank.scrollPageBackwards();
    }

    @Override
    public void selectNextPage() {
        if (this.pageSize == 0) {
            return;
        }
        this.sceneBank.scrollPageForwards();
    }

    public void setMaxSlotCount(int maxSlotCount) {
        while (this.items.size() > this.itemCount) {
            this.items.remove(this.items.size() - 1);
        }
        this.itemCount = maxSlotCount;
    }
}

