/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data.bank;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.data.IDeviceMetadata;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISceneBank;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.daw.data.empty.EmptyTrack;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.observer.IBankPageObserver;
import de.mossgrabers.framework.observer.IIndexedValueObserver;
import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.framework.daw.ApplicationImpl;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import de.mossgrabers.reaper.framework.daw.data.TrackImpl;
import de.mossgrabers.reaper.framework.daw.data.bank.AbstractPagedBankImpl;
import de.mossgrabers.reaper.framework.daw.data.bank.SlotBankImpl;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public abstract class AbstractTrackBankImpl
extends AbstractPagedBankImpl<TrackImpl, ITrack>
implements ITrackBank,
IBankPageObserver {
    private static final String SELECT_COMMAND = "/select";
    private final ApplicationImpl application;
    private final int numScenes;
    private final int numSends;
    private final int numParams;
    private final ISceneBank sceneBank;

    protected AbstractTrackBankImpl(DataSetupEx dataSetup, ApplicationImpl application, int numTracks, ISceneBank sceneBank, int numScenes, int numSends, int numParams) {
        super(dataSetup, numTracks, EmptyTrack.getInstance(numSends));
        this.application = application;
        this.numScenes = numScenes;
        this.numSends = numSends;
        this.numParams = numParams;
        this.sceneBank = sceneBank;
        this.sceneBank.addPageObserver(this);
    }

    @Override
    protected TrackImpl createItem(int position) {
        return new TrackImpl(this.dataSetup, this, position, this.getPageSize(), this.numSends, this.numScenes, this.numParams);
    }

    @Override
    public void pageAdjusted() {
        this.updateSlotBanks(this.sceneBank.getScrollPosition());
    }

    @Override
    public void toggleRecArm() {
        if (this.items.isEmpty()) {
            return;
        }
        boolean state = !((ITrack)this.items.get(0)).isRecArm();
        for (ITrack track : this.items) {
            track.setRecArm(state);
        }
    }

    @Override
    public void selectParent() {
    }

    @Override
    public boolean hasParent() {
        return false;
    }

    @Override
    public boolean isClipRecording() {
        return false;
    }

    @Override
    public String getSelectedChannelColorEntry() {
        Optional sel = this.getSelectedItem();
        if (sel.isEmpty()) {
            return DAWColor.COLOR_OFF.name();
        }
        return DAWColor.getColorID(((ITrack)sel.get()).getColor());
    }

    @Override
    public ISceneBank getSceneBank() {
        return this.sceneBank;
    }

    @Override
    public void stop(boolean isAlternative) {
    }

    @Override
    public void setIndication(boolean enable) {
    }

    @Override
    public void addNameObserver(IIndexedValueObserver<String> observer) {
        for (int index = 0; index < this.getPageSize(); ++index) {
            ITrack track = (ITrack)this.getUnpagedItem(index);
            track.addNameObserver((String value) -> observer.update(track.getIndex(), (String)value));
        }
    }

    @Override
    public void scrollTo(int position) {
        this.scrollTo(position, true);
    }

    @Override
    public void scrollTo(int position, boolean adjustPage) {
        if (position < 0 || position >= this.getItemCount()) {
            return;
        }
        int pageSize = this.getPageSize();
        int pos = adjustPage ? position / pageSize * pageSize : position;
        this.sendTrackOSC(pos + "/scrollto");
    }

    @Override
    protected void scrollPageBackwards() {
        super.scrollPageBackwards();
        Optional selectedTrack = this.getSelectedItem();
        if (selectedTrack.isPresent()) {
            this.sendTrackOSC(((ITrack)selectedTrack.get()).getPosition() + SELECT_COMMAND, 0);
        }
        int selIndex = this.pageSize - 1;
        int selPos = ((ITrack)this.getItem(selIndex)).getPosition();
        this.sendTrackOSC(selPos + SELECT_COMMAND, 1);
    }

    @Override
    protected void scrollPageForwards() {
        super.scrollPageForwards();
        Optional selectedTrack = this.getSelectedItem();
        if (selectedTrack.isPresent()) {
            this.sendTrackOSC(((ITrack)selectedTrack.get()).getPosition() + SELECT_COMMAND, 0);
        }
        int selPos = ((ITrack)this.getItem(0)).getPosition();
        this.sendTrackOSC(selPos + SELECT_COMMAND, 1);
    }

    protected void updateSlotBanks(int slotBankOffset) {
        int trackCount = this.items.size();
        for (int position = 0; position < trackCount; ++position) {
            ((SlotBankImpl)((TrackImpl)this.getUnpagedItem(position)).getSlotBank()).setBankOffset(slotBankOffset);
        }
    }

    public boolean hasSolo() {
        for (ITrack element : this.items) {
            if (!element.isSolo()) continue;
            return true;
        }
        return false;
    }

    public boolean hasMute() {
        for (ITrack element : this.items) {
            if (!element.isMute()) continue;
            return true;
        }
        return false;
    }

    public void clearSolo() {
        for (ITrack element : this.items) {
            element.setSolo(false);
        }
    }

    public void clearMute() {
        for (ITrack element : this.items) {
            element.setMute(false);
        }
    }

    @Override
    public void addChannel(ChannelType type) {
        this.addChannel(type, null);
    }

    @Override
    public void addChannel(ChannelType type, String name) {
        this.addChannel(type, name, DAWColor.getNextColor().getColor());
    }

    @Override
    public void addChannel(ChannelType type, String name, ColorEx color) {
        this.application.addChannel(type, name, color, Collections.emptyList());
    }

    @Override
    public void addChannel(ChannelType type, String name, List<IDeviceMetadata> devices) {
        this.application.addChannel(type, name, DAWColor.getNextColor().getColor(), devices);
    }

    protected void sendTrackOSC(String command, int value) {
        this.sender.processIntArg(Processor.TRACK, command, value);
    }

    protected void sendTrackOSC(String command) {
        this.sender.processNoArg(Processor.TRACK, command);
    }
}

