/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data;

import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.observer.IValueObserver;
import de.mossgrabers.framework.parameter.AbstractParameterImpl;
import de.mossgrabers.framework.utils.StringUtils;
import de.mossgrabers.reaper.framework.daw.data.ChannelImpl;

public class MuteParameterImpl
extends AbstractParameterImpl {
    private final ChannelImpl channel;

    public MuteParameterImpl(IValueChanger valueChanger, ChannelImpl channel, int index) {
        super(valueChanger, index);
        this.channel = channel;
    }

    @Override
    public boolean doesExist() {
        return this.channel.doesExist();
    }

    @Override
    public String getName() {
        return "Mute";
    }

    @Override
    public String getName(int limit) {
        return StringUtils.limit(this.getName(), limit);
    }

    @Override
    public void addNameObserver(IValueObserver<String> observer) {
    }

    @Override
    public int getValue() {
        return this.valueChanger.fromNormalizedValue(this.channel.isMute() ? 1.0 : 0.0);
    }

    @Override
    public void setValue(IValueChanger valueChanger, int value) {
        this.channel.setMute(value > 0);
    }

    @Override
    public void setNormalizedValue(double value) {
        this.channel.setMute(value > 0.0);
    }

    @Override
    public void changeValue(IValueChanger valueChanger, int value) {
        this.channel.setMute(valueChanger.isIncrease(value));
    }

    @Override
    public void setValueImmediatly(int value) {
        this.channel.setMute(value > 0);
    }

    @Override
    public void inc(double increment) {
        this.channel.setMute(increment > 0.0);
    }

    @Override
    public void resetValue() {
        this.channel.setMute(false);
    }

    @Override
    public void touchValue(boolean isBeingTouched) {
    }

    @Override
    public int getModulatedValue() {
        return this.getValue();
    }

    @Override
    public void setIndication(boolean enable) {
    }
}

