/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.utils;

import de.mossgrabers.framework.controller.color.ColorEx;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class StringUtils {
    private static final char[] REMOVABLE_CHARS = new char[]{' ', 'e', 'a', 'u', 'i', 'o'};

    private StringUtils() {
    }

    public static String pad(String str, int length) {
        return StringUtils.pad(str, length, ' ');
    }

    public static String pad(String str, int length, char character) {
        String text = str == null ? "" : str;
        int diff = length - text.length();
        if (diff == 0) {
            return text;
        }
        if (diff < 0) {
            return text.substring(0, length);
        }
        StringBuilder sb = new StringBuilder(text.length() + diff).append(text);
        for (int i = 0; i < diff; ++i) {
            sb.append(character);
        }
        return sb.toString();
    }

    public static String shortenAndFixASCII(String text, int length) {
        return StringUtils.optimizeName(StringUtils.fixASCII(text), length);
    }

    public static String fixASCII(String text) {
        if (text == null) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c > '\u007f') {
                switch (c) {
                    case '\u00c4': {
                        str.append("Ae");
                        break;
                    }
                    case '\u00e4': {
                        str.append("ae");
                        break;
                    }
                    case '\u00d6': 
                    case '\u0152': {
                        str.append("Oe");
                        break;
                    }
                    case '\u00f6': 
                    case '\u0153': {
                        str.append("oe");
                        break;
                    }
                    case '\u00dc': {
                        str.append("Ue");
                        break;
                    }
                    case '\u00fc': {
                        str.append("ue");
                        break;
                    }
                    case '\u00df': {
                        str.append("ss");
                        break;
                    }
                    case '\u00e9': 
                    case '\u00ea': {
                        str.append("e");
                        break;
                    }
                    case '\u00ef': 
                    case '\u012b': {
                        str.append("i");
                        break;
                    }
                    case '\u0101': {
                        str.append("a");
                        break;
                    }
                    case '\u2192': {
                        str.append("->");
                        break;
                    }
                    case '\u266f': {
                        str.append("#");
                        break;
                    }
                    case '\u2013': {
                        str.append("-");
                        break;
                    }
                    case '\u00bc': {
                        str.append("1/4");
                        break;
                    }
                    case '\u2155': {
                        str.append("1/5");
                        break;
                    }
                    case '\u2159': {
                        str.append("1/6");
                        break;
                    }
                    case '\u2019': {
                        str.append("'");
                        break;
                    }
                    case '\u00b1': {
                        str.append("+-");
                        break;
                    }
                    case '\u1d3e': {
                        str.append("p");
                        break;
                    }
                    default: {
                        str.append("?");
                        break;
                    }
                }
                continue;
            }
            str.append(c);
        }
        return str.toString();
    }

    public static String fixFontCharacters(String text) {
        if (text == null) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\u266f') {
                str.append("#");
                continue;
            }
            str.append(c);
        }
        return str.toString();
    }

    public static String asciiToHex(String asciiText) {
        int[] array = new int[asciiText.length()];
        for (int i = 0; i < asciiText.length(); ++i) {
            array[i] = asciiText.charAt(i);
        }
        return StringUtils.toHexStr(array);
    }

    public static String optimizeName(String text, int length) {
        if (text == null) {
            return "";
        }
        Object shortened = text;
        for (char element : REMOVABLE_CHARS) {
            int pos;
            if (((String)shortened).length() <= length) {
                return shortened;
            }
            while ((pos = ((String)shortened).indexOf(element)) != -1) {
                if (((String)(shortened = ((String)shortened).substring(0, pos) + ((String)shortened).substring(pos + 1, ((String)shortened).length()))).length() > length) continue;
                return shortened;
            }
        }
        return ((String)shortened).length() <= length ? shortened : ((String)shortened).substring(0, length);
    }

    public static String limit(String text, int length) {
        if (text == null) {
            return "";
        }
        return text.length() <= length ? text : text.substring(0, length);
    }

    public static String toHexStr(int[] data) {
        return StringUtils.toHexStr(data, true);
    }

    public static String toHexStr(int[] data, boolean addSpace) {
        StringBuilder sysex = new StringBuilder();
        for (int d : data) {
            sysex.append(StringUtils.toHexStr(d));
            if (!addSpace) continue;
            sysex.append(' ');
        }
        return sysex.toString();
    }

    public static String toHexStr(ByteBuffer data) {
        StringBuilder sysex = new StringBuilder();
        while (data.position() < data.limit()) {
            sysex.append(StringUtils.toHexStr(Byte.toUnsignedInt(data.get()))).append(' ');
        }
        return sysex.toString();
    }

    public static String toHexStr(byte[] data) {
        StringBuilder sysex = new StringBuilder();
        for (byte d : data) {
            sysex.append(StringUtils.toHexStr(Byte.toUnsignedInt(d))).append(' ');
        }
        return sysex.toString();
    }

    public static String toHexStr(int number) {
        return String.format("%02X", number);
    }

    public static int fromHexStr(String data, int index) {
        int pos = index * 2;
        return Integer.parseInt(data.substring(pos, pos + 2), 16);
    }

    public static int[] fromHexStr(String data) {
        int length = data.length();
        if (length % 2 != 0) {
            throw new IllegalArgumentException("Length of hex data must be a multiple of 2!");
        }
        int size = length / 2;
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            int pos = i * 2;
            result[i] = Integer.parseInt(data.substring(pos, pos + 2), 16);
        }
        return result;
    }

    public static byte[] asBytes(int[] data) {
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            bytes[i] = (byte)data[i];
        }
        return bytes;
    }

    public static String integerArrayToString(int start, int length, int[] data) {
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append((char)data[start + i]);
        }
        return sb.toString();
    }

    public static String formatPercentage(double noteVelocity) {
        DecimalFormat df = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        df.setMaximumFractionDigits(1);
        return df.format((Object)(noteVelocity * 100.0)) + "%";
    }

    public static String formatMeasures(int quartersPerMeasure, double beats, int startOffset, boolean includeFrames) {
        return StringUtils.formatMeasures(quartersPerMeasure, beats, startOffset, includeFrames, "%d.%d.%d", "%d.%d.%d:%03d");
    }

    public static String formatMeasuresLong(int quartersPerMeasure, double beats, int startOffset, boolean includeFrames) {
        return StringUtils.formatMeasures(quartersPerMeasure, beats, startOffset, includeFrames, "%03d.%d.%d", "%d.%02d.%02d:%02d");
    }

    public static String formatTime(double tempo, double beats, boolean includeFrames) {
        return StringUtils.formatTime(tempo, beats, includeFrames, "%d.%d.%d", "%d.%d.%d:%03d");
    }

    public static String formatTimeLong(double tempo, double beats, boolean includeFrames) {
        return StringUtils.formatTime(tempo, beats, includeFrames, "%02d.%02d.%02d", "%d.%02d.%02d:%03d");
    }

    private static String formatMeasures(int quartersPerMeasure, double beats, int startOffset, boolean includeFrames, String shortFormat, String longFormat) {
        int measure = (int)Math.floor(beats / (double)quartersPerMeasure);
        double t = beats - (double)(measure * quartersPerMeasure);
        int quarters = (int)Math.floor(t);
        int eights = (int)Math.floor((t -= (double)quarters) / 0.25);
        if (!includeFrames) {
            return String.format(shortFormat, measure + startOffset, quarters + startOffset, eights + startOffset);
        }
        int frames = (int)Math.floor((t -= (double)eights * 0.25) / 0.25 * 100.0);
        return String.format(longFormat, measure + startOffset, quarters + startOffset, eights + startOffset, frames);
    }

    private static String formatTime(double tempo, double beats, boolean includeFrames, String shortFormat, String longFormat) {
        double time = beats * 60.0 / tempo;
        int seconds = (int)Math.floor(time % 60.0);
        double t = (time - (double)seconds) / 60.0;
        int minutes = (int)Math.floor(t % 60.0);
        t = (t - (double)minutes) / 60.0;
        int hours = (int)Math.floor(t);
        if (!includeFrames) {
            return String.format(shortFormat, minutes, seconds);
        }
        int millis = (int)((time - (double)((hours * 60 + minutes) * 60 + seconds)) * 1000.0);
        return String.format(longFormat, hours, minutes, seconds, millis);
    }

    public static String formatColor(ColorEx color) {
        return StringUtils.toHexStr(color.toIntRGB255(), false);
    }
}

