/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.graphics.canvas.component;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.graphics.Align;
import de.mossgrabers.framework.graphics.IGraphicsConfiguration;
import de.mossgrabers.framework.graphics.IGraphicsContext;
import de.mossgrabers.framework.graphics.IGraphicsDimensions;
import de.mossgrabers.framework.graphics.IGraphicsInfo;
import de.mossgrabers.framework.graphics.canvas.component.IComponent;
import de.mossgrabers.framework.utils.Pair;
import java.util.ArrayList;
import java.util.List;

public class ListComponent
implements IComponent {
    private final List<Pair<String, Boolean>> items = new ArrayList<Pair<String, Boolean>>(6);

    public ListComponent(List<Pair<String, Boolean>> items) {
        this.items.addAll(items);
    }

    @Override
    public void draw(IGraphicsInfo info) {
        ColorEx borderColor;
        IGraphicsContext gc = info.getContext();
        IGraphicsDimensions dimensions = info.getDimensions();
        IGraphicsConfiguration configuration = info.getConfiguration();
        double left = info.getBounds().left();
        double width = info.getBounds().width();
        double height = info.getBounds().height();
        double separatorSize = dimensions.getSeparatorSize();
        double inset = dimensions.getInset();
        int size = this.items.size();
        double itemLeft = left + separatorSize;
        double itemWidth = width - separatorSize;
        double itemHeight = height / (double)size;
        ColorEx textColor = configuration.getColorText();
        if (textColor.equals(borderColor = configuration.getColorBorder())) {
            textColor = ColorEx.calcContrastColor(textColor);
        }
        for (int i = 0; i < size; ++i) {
            Pair<String, Boolean> item = this.items.get(i);
            boolean isSelected = item.getValue();
            double itemTop = (double)i * itemHeight;
            gc.fillRectangle(itemLeft, itemTop + separatorSize, itemWidth, itemHeight - 2.0 * separatorSize, isSelected ? textColor : borderColor);
            gc.drawTextInBounds(item.getKey(), itemLeft + inset, itemTop, itemWidth - 2.0 * inset, itemHeight, Align.LEFT, isSelected ? borderColor : textColor, itemHeight * 0.6);
        }
    }

    public int hashCode() {
        int prime = 31;
        boolean result = true;
        return 31 + this.items.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ListComponent other = (ListComponent)obj;
        return this.items.equals(other.items);
    }
}

