/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.yaeltex.turn.view;

import de.mossgrabers.controller.yaeltex.turn.YaeltexTurnConfiguration;
import de.mossgrabers.controller.yaeltex.turn.controller.YaeltexTurnColorManager;
import de.mossgrabers.controller.yaeltex.turn.controller.YaeltexTurnControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.grid.LightInfo;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.view.AbstractSessionView;

public class SessionView
extends AbstractSessionView<YaeltexTurnControlSurface, YaeltexTurnConfiguration> {
    public SessionView(YaeltexTurnControlSurface surface, IModel model) {
        super("Session", surface, model, 4, 8, true);
        int red = YaeltexTurnColorManager.getIndexFor(ColorEx.RED);
        int redLow = YaeltexTurnColorManager.getIndexFor(ColorEx.DARK_RED);
        int green = YaeltexTurnColorManager.getIndexFor(ColorEx.GREEN);
        int orange = YaeltexTurnColorManager.getIndexFor(ColorEx.ORANGE);
        int black = YaeltexTurnColorManager.getIndexFor(ColorEx.BLACK);
        int darkGray = YaeltexTurnColorManager.getIndexFor(ColorEx.DARK_GRAY);
        LightInfo isRecording = new LightInfo(red, red, false);
        LightInfo isRecordingQueued = new LightInfo(red, redLow, true);
        LightInfo isPlaying = new LightInfo(green, green, false);
        LightInfo isPlayingQueued = new LightInfo(green, green, true);
        LightInfo isStopQueued = new LightInfo(green, green, true);
        LightInfo hasContent = new LightInfo(orange, -1, false);
        LightInfo noContent = new LightInfo(black, -1, false);
        LightInfo recArmed = new LightInfo(redLow, -1, false);
        LightInfo isMuted = new LightInfo(darkGray, -1, false);
        this.setColors(isRecording, isRecordingQueued, isPlaying, isPlayingQueued, isStopQueued, hasContent, noContent, recArmed, isMuted);
    }

    @Override
    protected boolean handleButtonCombinations(ITrack track, ISlot slot) {
        if (super.handleButtonCombinations(track, slot)) {
            return true;
        }
        int index = track.getIndex();
        if (index < 0) {
            return true;
        }
        if (((YaeltexTurnControlSurface)this.surface).isSelectPressed()) {
            slot.select();
            return true;
        }
        if (this.isButtonCombination(ButtonID.get(ButtonID.ROW1_1, index))) {
            slot.duplicate();
            return true;
        }
        if (this.isButtonCombination(ButtonID.get(ButtonID.ROW6_1, index))) {
            slot.remove();
            return true;
        }
        return false;
    }
}

