/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.slmkiii.mode;

import de.mossgrabers.controller.novation.slmkiii.SLMkIIIConfiguration;
import de.mossgrabers.controller.novation.slmkiii.controller.SLMkIIIControlSurface;
import de.mossgrabers.controller.novation.slmkiii.controller.SLMkIIIDisplay;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.IBank;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.utils.ButtonEvent;

public abstract class BaseMode<B extends IItem>
extends AbstractParameterMode<SLMkIIIControlSurface, SLMkIIIConfiguration, B> {
    protected static final int SCROLL_RATE = 8;
    private int movementCounter = 0;

    protected BaseMode(String name, SLMkIIIControlSurface surface, IModel model) {
        super(name, surface, model, true);
    }

    protected BaseMode(String name, SLMkIIIControlSurface surface, IModel model, IBank<B> bank) {
        super(name, surface, model, false, bank, DEFAULT_KNOB_IDS);
    }

    @Override
    public void onActivate() {
        super.onActivate();
        ((SLMkIIIControlSurface)this.surface).getDisplay().setDisplayLayout(SLMkIIIDisplay.SCREEN_LAYOUT_KNOB);
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        if (event == ButtonEvent.UP) {
            ((ITrack)this.model.getCurrentTrackBank().getItem(index)).select();
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        return 0;
    }

    public abstract int getModeColor();

    protected boolean increaseKnobMovement() {
        ++this.movementCounter;
        if (this.movementCounter < 8) {
            return false;
        }
        this.movementCounter = 0;
        return true;
    }

    protected void setButtonInfo(SLMkIIIDisplay display) {
        display.setPropertyColor(8, 0, this.getModeColor());
        if (((SLMkIIIControlSurface)this.surface).isMuteSolo()) {
            display.setCell(2, 8, "Mute").setCell(3, 8, "Solo");
            display.setPropertyColor(8, 1, 96);
            display.setPropertyColor(8, 2, 13);
        } else {
            display.setCell(2, 8, "Monitor").setCell(3, 8, "Arm");
            display.setPropertyColor(8, 1, 21);
            display.setPropertyColor(8, 2, 5);
        }
    }
}

