/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.sl.command.trigger;

import de.mossgrabers.controller.novation.sl.view.SLView;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;

public class ButtonRowSelectCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    private final int row;

    public ButtonRowSelectCommand(int row, IModel model, S surface) {
        super(model, surface);
        this.row = row;
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        IView view = (IView)this.surface.getViewManager().getActive();
        if (view == null) {
            return;
        }
        ModeManager modeManager = this.surface.getModeManager();
        switch (this.row) {
            case 0: {
                ((SLView)((Object)view)).onButtonRow1Select();
                break;
            }
            case 1: {
                modeManager.setActive(Modes.DEVICE_PARAMS);
                this.model.getHost().showNotification("Device Parameters");
                break;
            }
            case 2: {
                ((SLView)((Object)view)).onButtonRow2Select();
                break;
            }
            case 3: {
                modeManager.setActive(Modes.TRACK);
                this.model.getHost().showNotification("Track");
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                modeManager.setActive(Modes.VOLUME);
                this.model.getHost().showNotification("Volume");
                break;
            }
        }
    }
}

