/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchkey.maxi.controller;

import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.grid.PadGridImpl;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.view.Views;
import java.util.HashMap;
import java.util.Map;

public class LaunchkeyPadGrid
extends PadGridImpl {
    private static final int[] MAP_DRUM = new int[]{36, 37, 38, 39, 44, 45, 46, 47, 40, 41, 42, 43, 48, 49, 50, 51};
    private static final int[] MAP_SESSION = new int[]{112, 113, 114, 115, 116, 117, 118, 119, 96, 97, 98, 99, 100, 101, 102, 103};
    private static final int[] MAP_DEVICE_SELECT = new int[]{80, 81, 82, 83, 84, 85, 86, 87, 64, 65, 66, 67, 68, 69, 70, 71};
    private static final Map<Integer, Integer> INVERSE_MAP_DRUM = new HashMap<Integer, Integer>(16);
    private static final Map<Integer, Integer> INVERSE_MAP_SESSION = new HashMap<Integer, Integer>(16);
    private static final Map<Integer, Integer> INVERSE_MAP_DEVICE_SELECT = new HashMap<Integer, Integer>(16);
    private Views activeView;

    public LaunchkeyPadGrid(ColorManager colorManager, IMidiOutput output) {
        super(colorManager, output, 2, 8, 36);
    }

    @Override
    public int translateToGrid(int note) {
        if (this.activeView == null) {
            return note;
        }
        Integer n = note;
        Integer inverse = switch (this.activeView) {
            case Views.DRUM -> INVERSE_MAP_DRUM.get(n);
            case Views.DEVICE -> INVERSE_MAP_DEVICE_SELECT.get(n);
            default -> INVERSE_MAP_SESSION.get(n);
        };
        return inverse == null ? note : inverse;
    }

    @Override
    public int[] translateToController(int note) {
        return LaunchkeyPadGrid.translateToController(this.activeView, note);
    }

    public static int[] translateToController(Views view, int note) {
        if (view == null) {
            return new int[]{0, note};
        }
        int[] result = new int[2];
        int n = note - 36;
        switch (view) {
            case DRUM: {
                result[0] = 9;
                result[1] = MAP_DRUM[n];
                break;
            }
            case DEVICE: {
                result[0] = 0;
                result[1] = MAP_DEVICE_SELECT[n];
                break;
            }
            default: {
                result[0] = 0;
                result[1] = MAP_SESSION[n];
            }
        }
        return result;
    }

    @Override
    protected void sendNoteState(int channel, int note, int color) {
        if (this.activeView != null && this.activeView == Views.DRUM) {
            this.output.sendNoteEx(9, note, color);
        } else {
            this.output.sendNote(note, color);
        }
    }

    @Override
    protected void sendBlinkState(int channel, int note, int blinkColor, boolean fast) {
        if (this.activeView != null && this.activeView == Views.DRUM) {
            this.output.sendNoteEx(9 + (fast ? 1 : 2), note, blinkColor);
        } else {
            this.output.sendNoteEx(fast ? 1 : 2, note, blinkColor);
        }
    }

    public void setView(Views view) {
        this.activeView = view;
    }

    static {
        for (int i = 0; i < 16; ++i) {
            Integer note = 36 + i;
            INVERSE_MAP_DRUM.put(MAP_DRUM[i], note);
            INVERSE_MAP_SESSION.put(MAP_SESSION[i], note);
            INVERSE_MAP_DEVICE_SELECT.put(MAP_DEVICE_SELECT[i], note);
        }
    }
}

