/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchcontrol;

import de.mossgrabers.framework.controller.DefaultControllerDefinition;
import de.mossgrabers.framework.utils.OperatingSystem;
import de.mossgrabers.framework.utils.Pair;
import java.util.List;
import java.util.UUID;

public class LaunchControlXLControllerDefinition
extends DefaultControllerDefinition {
    private static final UUID EXTENSION_ID = UUID.fromString("5AFA5045-FF92-4737-A091-5B371CD5E529");
    private static final String LAUNCH_CONTROL_XL = "Launch Control XL";

    public LaunchControlXLControllerDefinition() {
        super(EXTENSION_ID, LAUNCH_CONTROL_XL, "Novation", 1, 1);
    }

    @Override
    public List<Pair<String[], String[]>> getMidiDiscoveryPairs(OperatingSystem os) {
        List<Pair<String[], String[]>> midiDiscoveryPairs = super.getMidiDiscoveryPairs(os);
        switch (os) {
            default: {
                String pattern = "%sLaunch Control XL";
                midiDiscoveryPairs.addAll(this.createWindowsDeviceDiscoveryPairs("%sLaunch Control XL", "%sLaunch Control XL"));
                break;
            }
            case MAC: 
            case MAC_ARM: {
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair(LAUNCH_CONTROL_XL));
                break;
            }
            case LINUX: {
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair(LAUNCH_CONTROL_XL));
                midiDiscoveryPairs.add(this.addDeviceDiscoveryPair("Launch Control XL Launch Contro"));
            }
        }
        return midiDiscoveryPairs;
    }
}

