/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3.command.trigger;

import de.mossgrabers.controller.ni.maschine.mk3.MaschineConfiguration;
import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.framework.command.trigger.transport.StopCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;

public class MaschineStopCommand
extends StopCommand<MaschineControlSurface, MaschineConfiguration> {
    private boolean consumed;

    public MaschineStopCommand(IModel model, MaschineControlSurface surface) {
        super(model, surface);
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        if (!((MaschineControlSurface)this.surface).getMaschine().hasShift()) {
            ViewManager viewManager = ((MaschineControlSurface)this.surface).getViewManager();
            if (event == ButtonEvent.DOWN) {
                if (!viewManager.isActive(new Views[]{Views.SHIFT})) {
                    viewManager.setTemporary(Views.SHIFT);
                }
                return;
            }
            if (event != ButtonEvent.UP) {
                return;
            }
            if (viewManager.isActive(new Views[]{Views.SHIFT})) {
                viewManager.restore();
            }
            if (this.consumed) {
                this.consumed = false;
                return;
            }
        }
        super.executeNormal(event);
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        ITransport transport = this.model.getTransport();
        if (transport.isPlaying()) {
            this.handleStopOptions();
        } else {
            transport.stopAndRewind();
        }
    }

    public void setConsumed() {
        this.consumed = true;
    }
}

