/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.kontrol.mkii.controller;

import de.mossgrabers.controller.ni.kontrol.mkii.controller.IKontrolProtocolDeviceDescriptor;
import de.mossgrabers.framework.utils.OperatingSystem;
import de.mossgrabers.framework.utils.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class KontrolProtocolDeviceDescriptorV3
implements IKontrolProtocolDeviceDescriptor {
    private static final UUID EXTENSION_ID = UUID.fromString("DE2479B8-79B9-411F-8746-5E59032544AF");
    private static final String DEVICE_NAME = "Komplete Kontrol S-series mk3";
    private static final String[][][] PORTS_WINDOWS = new String[][][]{{{"MIDIIN2 (KONTROL S49 MK3)", "KONTROL S49 MK3"}, {"MIDIOUT2 (KONTROL S49 MK3)", "KONTROL S49 MK3"}}, {{"MIDIIN2 (KONTROL S61 MK3)", "KONTROL S61 MK3"}, {"MIDIOUT2 (KONTROL S61 MK3)", "KONTROL S61 MK3"}}, {{"MIDIIN2 (KONTROL S88 MK3)", "KONTROL S88 MK3"}, {"MIDIOUT2 (KONTROL S88 MK3)", "KONTROL S88 MK3"}}};
    private static final String[][] PORTS_MACOS = new String[][]{{"KONTROL S49 MK3 DAW", "KONTROL S49 MK3 Main"}, {"KONTROL S61 MK3 DAW", "KONTROL S61 MK3 Main"}, {"KONTROL S88 MK3 DAW", "KONTROL S88 MK3 Main"}};
    private static final String[][] PORTS_LINUX = new String[][]{{"KONTROL S49 MK3 KONTROL S49 MK3 #2", "KONTROL S49 MK3 KONTROL S49 MK3"}, {"KONTROL S61 MK3 KONTROL S61 MK3 #2", "KONTROL S61 MK3 KONTROL S61 MK3"}, {"KONTROL S88 MK3 KONTROL S88 MK3 #2", "KONTROL S88 MK3 KONTROL S88 MK3"}};

    @Override
    public UUID getID() {
        return EXTENSION_ID;
    }

    @Override
    public String getName() {
        return DEVICE_NAME;
    }

    @Override
    public List<Pair<String[], String[]>> getMidiDiscoveryPairs(OperatingSystem os) {
        ArrayList<Pair<String[], String[]>> midiDiscoveryPairs = new ArrayList<Pair<String[], String[]>>();
        switch (os) {
            case MAC: 
            case MAC_ARM: {
                for (String[] ports : PORTS_MACOS) {
                    midiDiscoveryPairs.add(new Pair<String[], String[]>(ports, ports));
                }
                break;
            }
            case WINDOWS: {
                for (String[][] ports : PORTS_WINDOWS) {
                    midiDiscoveryPairs.add(new Pair<String[], String[]>(ports[0], ports[1]));
                }
                break;
            }
            case LINUX: {
                for (String[] ports : PORTS_LINUX) {
                    midiDiscoveryPairs.add(new Pair<String[], String[]>(ports, ports));
                }
                break;
            }
        }
        return midiDiscoveryPairs;
    }
}

