/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.mcu.mode.device;

import de.mossgrabers.controller.mackie.mcu.MCUConfiguration;
import de.mossgrabers.controller.mackie.mcu.controller.MCUControlSurface;
import de.mossgrabers.controller.mackie.mcu.mode.BaseMode;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.bank.IBank;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.observer.IObserverManagement;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.IParameterProvider;
import de.mossgrabers.framework.parameterprovider.device.BankParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.RangeFilterParameterProvider;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.Arrays;
import java.util.Optional;

public class UserMode
extends BaseMode<IParameter> {
    protected IParameterProvider projectParameterProvider;
    protected IParameterProvider trackParameterProvider;
    protected boolean isProjectMode = true;

    public UserMode(MCUControlSurface surface, IModel model) {
        super("User Parameters", surface, model, model.getProject().getParameterBank());
        int surfaceID = surface.getSurfaceID();
        this.projectParameterProvider = new RangeFilterParameterProvider(new BankParameterProvider(model.getProject().getParameterBank()), surfaceID * 8, 8);
        this.trackParameterProvider = new RangeFilterParameterProvider(new BankParameterProvider(model.getCursorTrack().getParameterBank()), surfaceID * 8, 8);
        this.setParameterProvider(this.projectParameterProvider);
    }

    @Override
    public void onKnobValue(int index, int value) {
        int extenderOffset = ((MCUControlSurface)this.surface).getExtenderOffset();
        ((IParameter)this.bank.getItem(extenderOffset + index)).changeValue(value);
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.setTouchedKnob(index, isTouched);
        IParameter param = (IParameter)this.bank.getItem(index);
        if (param.doesExist()) {
            param.touchValue(isTouched);
        }
    }

    @Override
    public void updateDisplay() {
        IBank iBank;
        IObserverManagement param;
        this.drawDisplay2();
        ITextDisplay d = ((MCUControlSurface)this.surface).getTextDisplay().clear();
        ColorEx[] colors = new ColorEx[8];
        int extenderOffset = ((MCUControlSurface)this.surface).getExtenderOffset();
        int textLength = this.getTextLength();
        for (int i = 0; i < 8; ++i) {
            param = (IParameter)this.bank.getItem(extenderOffset + i);
            d.setCell(0, i, param.doesExist() ? StringUtils.shortenAndFixASCII(param.getName(textLength), textLength) : "");
            d.setCell(1, i, StringUtils.shortenAndFixASCII(param.getDisplayedValue(textLength), textLength));
            colors[i] = param.doesExist() ? ColorEx.WHITE : ColorEx.BLACK;
        }
        if (((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).getMainDisplayType() == MCUConfiguration.MainDisplay.ASPARION && ((MCUControlSurface)this.surface).getSurfaceID() == 0) {
            IParameterBank parameterBank;
            Optional selectedPage;
            d.clearRow(0);
            d.setCell(0, 0, this.isProjectMode ? "Project" : "Track");
            d.setCell(0, 1, "Parameters");
            param = this.bank;
            if (param instanceof IParameterBank && (selectedPage = (parameterBank = (IParameterBank)param).getPageBank().getSelectedItem()).isPresent()) {
                d.setCell(0, 2, StringUtils.shortenAndFixASCII((String)selectedPage.get(), this.getTextLength()));
            }
        }
        d.allDone();
        ((MCUControlSurface)this.surface).sendDisplayColor(colors);
        int[] indices = new int[8];
        Arrays.fill(indices, 0);
        if (this.getExtenderOffset() == 0 && (iBank = this.bank) instanceof IParameterBank) {
            IParameterBank parameterBank = (IParameterBank)iBank;
            indices[2] = parameterBank.getPageBank().getSelectedItemIndex() + 1;
        }
        ((MCUControlSurface)this.surface).setItemIndices(indices);
    }

    @Override
    public void updateKnobLEDs() {
        int upperBound = this.model.getValueChanger().getUpperBound();
        int extenderOffset = ((MCUControlSurface)this.surface).getExtenderOffset();
        for (int i = 0; i < 8; ++i) {
            IParameter param = (IParameter)this.bank.getItem(extenderOffset + i);
            ((MCUControlSurface)this.surface).setKnobLED(i, 0, param.doesExist() ? Math.max(1, param.getValue()) : 0, upperBound);
        }
    }

    @Override
    protected void resetParameter(int index) {
        int extenderOffset = ((MCUControlSurface)this.surface).getExtenderOffset();
        this.resetParameter((IParameter)this.bank.getItem(extenderOffset + index));
    }

    public void setMode(boolean isProjectMode) {
        this.isProjectMode = isProjectMode;
        this.switchBanks(this.isProjectMode ? this.model.getProject().getParameterBank() : this.model.getCursorTrack().getParameterBank());
        this.setParameterProvider(this.isProjectMode ? this.projectParameterProvider : this.trackParameterProvider);
        this.bindControls();
    }

    public IBank<?> getParameterBank() {
        return this.bank;
    }

    public boolean isProjectMode() {
        return this.isProjectMode;
    }
}

