/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.mcu.command.trigger;

import de.mossgrabers.controller.mackie.mcu.MCUConfiguration;
import de.mossgrabers.controller.mackie.mcu.command.trigger.ModeSwitcher;
import de.mossgrabers.controller.mackie.mcu.controller.MCUControlSurface;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.command.trigger.Direction;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;

public class MCUCursorCommand
extends AbstractTriggerCommand<MCUControlSurface, MCUConfiguration> {
    protected Direction direction;
    private final ModeSwitcher switcher;

    public MCUCursorCommand(Direction direction, IModel model, MCUControlSurface surface) {
        super(model, surface);
        this.direction = direction;
        this.switcher = new ModeSwitcher(surface);
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        if (event != ButtonEvent.UP) {
            return;
        }
        IBrowser browser = this.model.getBrowser();
        if (browser.isActive()) {
            switch (this.direction) {
                case LEFT: {
                    browser.insertBeforeCursorDevice();
                    break;
                }
                case RIGHT: {
                    browser.insertAfterCursorDevice();
                    break;
                }
                case UP: {
                    browser.nextContentType();
                    break;
                }
                case DOWN: {
                    browser.previousContentType();
                }
            }
            return;
        }
        switch (this.direction) {
            case LEFT: {
                this.scrollLeft();
                break;
            }
            case RIGHT: {
                this.scrollRight();
                break;
            }
            case UP: {
                this.scrollUp();
                break;
            }
            case DOWN: {
                this.scrollDown();
            }
        }
    }

    private void scrollLeft() {
        if (((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).isZoomState()) {
            this.model.getApplication().zoomOut();
        } else {
            this.model.getApplication().arrowKeyLeft();
        }
    }

    private void scrollRight() {
        if (((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).isZoomState()) {
            this.model.getApplication().zoomIn();
        } else {
            this.model.getApplication().arrowKeyRight();
        }
    }

    private void scrollUp() {
        if (((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).isZoomState()) {
            if (((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).useVertZoomForModes()) {
                this.switcher.scrollUp();
            } else {
                this.model.getApplication().decTrackHeight();
            }
        } else {
            this.model.getApplication().arrowKeyUp();
        }
    }

    private void scrollDown() {
        if (((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).isZoomState()) {
            if (((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).useVertZoomForModes()) {
                this.switcher.scrollDown();
            } else {
                this.model.getApplication().incTrackHeight();
            }
        } else {
            this.model.getApplication().arrowKeyDown();
        }
    }
}

