/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.arturia.beatstep.command.continuous;

import de.mossgrabers.controller.arturia.beatstep.BeatstepConfiguration;
import de.mossgrabers.controller.arturia.beatstep.controller.BeatstepControlSurface;
import de.mossgrabers.controller.arturia.beatstep.view.BeatstepView;
import de.mossgrabers.framework.command.core.AbstractContinuousCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.IView;

public class KnobRowViewCommand
extends AbstractContinuousCommand<BeatstepControlSurface, BeatstepConfiguration> {
    private final int index;

    public KnobRowViewCommand(int index, IModel model, BeatstepControlSurface surface) {
        super(model, surface);
        this.index = index;
    }

    @Override
    public void execute(int value) {
        IView v = (IView)((BeatstepControlSurface)this.surface).getViewManager().getActive();
        if (v == null) {
            return;
        }
        double knobChange = this.model.getValueChanger().calcKnobChange(value);
        if (knobChange == 0.0) {
            return;
        }
        knobChange = Math.min(10.0, Math.max(-10.0, knobChange));
        ((BeatstepView)((Object)v)).onKnob(this.index, (int)knobChange + 64);
    }
}

