/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode.device;

import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.device.DeviceLayerMode;
import de.mossgrabers.controller.ableton.push.parameterprovider.PushPanLayerOrDrumPadParameterProvider;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IChannel;
import de.mossgrabers.framework.daw.data.ILayer;
import java.util.Optional;

public class DeviceLayerPanMode
extends DeviceLayerMode {
    public DeviceLayerPanMode(PushControlSurface surface, IModel model) {
        super("Layer Panning", surface, model);
        this.setParameterProvider(new PushPanLayerOrDrumPadParameterProvider(this.cursorDevice));
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.setTouchedKnob(index, isTouched);
        int offset = this.getDrumPadIndex();
        IChannel layer = (IChannel)this.bank.getItem(offset + index);
        if (!layer.doesExist()) {
            return;
        }
        if (isTouched && ((PushControlSurface)this.surface).isDeletePressed()) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
            layer.resetPan();
        }
        layer.touchPan(isTouched);
        this.checkStopAutomationOnKnobRelease(isTouched);
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        if (!this.cursorDevice.hasLayers()) {
            display.setBlock(1, 1, "    This device  ").setBlock(1, 2, "does not have layers.");
        } else if (!this.bank.hasExistingItems()) {
            display.setBlock(1, 1, "    Please create").setBlock(1, 2, this.cursorDevice.hasDrumPads() ? "a Drum Pad..." : "a Device Layer...");
        } else {
            int offset = this.getDrumPadIndex();
            for (int i = 0; i < 8; ++i) {
                IChannel layer = (IChannel)this.bank.getItem(offset + i);
                display.setCell(0, i, layer.doesExist() ? "Pan" : "").setCell(1, i, layer.getPanStr(8));
                if (!layer.doesExist()) continue;
                display.setCell(2, i, layer.getPan(), Format.FORMAT_PAN);
            }
        }
        this.drawRow4(display);
    }

    @Override
    public void updateDisplayElements(IGraphicDisplay display, Optional<ILayer> l) {
        this.updateChannelDisplay(display, 2, false, true);
    }
}

