/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data;

import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.observer.IValueObserver;
import de.mossgrabers.framework.utils.StringUtils;
import de.mossgrabers.reaper.framework.daw.BaseImpl;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import java.util.HashSet;
import java.util.Set;

public abstract class ItemImpl
extends BaseImpl
implements IItem {
    protected int index;
    protected int position;
    protected boolean exists = false;
    protected String name = null;
    private boolean selected;
    private final Set<IValueObserver<String>> nameObservers = new HashSet<IValueObserver<String>>();

    protected ItemImpl(DataSetupEx dataSetup, int index) {
        super(dataSetup);
        this.index = index;
    }

    @Override
    public boolean doesExist() {
        return this.exists;
    }

    public void setExists(boolean exists) {
        this.exists = exists;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        if (position >= 0) {
            this.position = position;
        }
    }

    @Override
    public String getName() {
        return this.exists && this.name != null ? this.name : "";
    }

    @Override
    public String getName(int limit) {
        return StringUtils.optimizeName(this.getName(), limit);
    }

    @Override
    public void addNameObserver(IValueObserver<String> observer) {
        this.nameObservers.add(observer);
    }

    @Override
    public void setName(String name) {
    }

    public void setInternalName(String name) {
        if (this.name != null && this.name.equals(name)) {
            return;
        }
        this.name = name == null ? "" : name;
        this.nameObservers.forEach(observer -> observer.update(this.name));
    }

    @Override
    public boolean isSelected() {
        return this.doesExist() && this.selected;
    }

    @Override
    public void setSelected(boolean isSelected) {
        this.selected = isSelected;
    }

    @Override
    public void select() {
    }

    @Override
    public void toggleMultiSelect() {
    }

    protected void sendPositionedItemOSC(String command) {
        this.sender.processNoArg(this.getProcessor(), this.createCommand(command));
    }

    protected void sendPositionedItemOSC(String command, int value) {
        this.sender.processIntArg(this.getProcessor(), this.createCommand(command), value);
    }

    protected void sendPositionedItemOSC(String command, boolean value) {
        this.sender.processIntArg(this.getProcessor(), this.createCommand(command), value ? 1 : 0);
    }

    public void sendPositionedItemOSC(String command, double value) {
        this.sender.processDoubleArg(this.getProcessor(), this.createCommand(command), value);
    }

    protected void sendPositionedItemOSC(String command, String value) {
        this.sender.processStringArg(this.getProcessor(), this.createCommand(command), value);
    }

    protected String createCommand(String command) {
        return this.getPosition() + "/" + command;
    }
}

