/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.parameterprovider.special;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.daw.data.empty.EmptyParameter;
import de.mossgrabers.framework.observer.IParametersAdjustObserver;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.IParameterProvider;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class CombinedParameterProvider
implements IParameterProvider {
    private final List<IParameterProvider> providers;
    private final int overallSize;

    public CombinedParameterProvider(IParameterProvider ... providers) {
        this(Arrays.asList(providers));
    }

    public CombinedParameterProvider(List<IParameterProvider> providers) {
        this.providers = providers;
        int size = 0;
        for (IParameterProvider provider : this.providers) {
            size += provider.size();
        }
        this.overallSize = size;
    }

    @Override
    public int size() {
        return this.overallSize;
    }

    @Override
    public IParameter get(int index) {
        int pos = index;
        for (IParameterProvider provider : this.providers) {
            int size = provider.size();
            if (pos < size) {
                return provider.get(pos);
            }
            pos -= size;
        }
        return EmptyParameter.INSTANCE;
    }

    @Override
    public Optional<ColorEx> getColor(int index) {
        int pos = index;
        for (IParameterProvider provider : this.providers) {
            int size = provider.size();
            if (pos < size) {
                return provider.getColor(pos);
            }
            pos -= size;
        }
        return Optional.empty();
    }

    @Override
    public void addParametersObserver(IParametersAdjustObserver observer) {
        for (IParameterProvider provider : this.providers) {
            provider.addParametersObserver(observer);
        }
    }

    @Override
    public void removeParametersObserver(IParametersAdjustObserver observer) {
        for (IParameterProvider provider : this.providers) {
            provider.removeParametersObserver(observer);
        }
    }

    @Override
    public Set<IParametersAdjustObserver> removeParametersObservers() {
        HashSet<IParametersAdjustObserver> observers = new HashSet<IParametersAdjustObserver>();
        for (IParameterProvider provider : this.providers) {
            observers.addAll(provider.removeParametersObservers());
        }
        return observers;
    }
}

