/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.clip;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.bank.ISlotBank;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.Optional;

public class NewCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    public NewCommand(IModel model, S surface) {
        super(model, surface);
    }

    public void execute() {
        this.handleExecute(true);
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event == ButtonEvent.UP) {
            this.handleExecute(true);
        }
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event == ButtonEvent.UP) {
            this.handleExecute(false);
        }
    }

    public void handleExecute(boolean enableOverdub) {
        ISlotBank slotBank;
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        if (!cursorTrack.doesExist()) {
            this.surface.getDisplay().notify("Please select an Instrument track first.");
            return;
        }
        Optional selectedSlot = (slotBank = cursorTrack.getSlotBank()).getSelectedItem();
        int slotIndex = selectedSlot.isEmpty() ? 0 : ((ISlot)selectedSlot.get()).getIndex();
        Optional<ISlot> slot = slotBank.getEmptySlot(slotIndex);
        if (slot.isEmpty()) {
            this.surface.getDisplay().notify("No empty slot in the current page. Please scroll down.");
            return;
        }
        this.model.createNoteClip(cursorTrack, slot.get(), this.getClipLength(), enableOverdub);
    }

    protected int getClipLength() {
        return this.surface.getConfiguration().getNewClipLenghthInBeats(this.model.getTransport().getQuartersPerMeasure());
    }
}

