/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.yaeltex.turn.controller;

import de.mossgrabers.controller.yaeltex.turn.YaeltexTurnConfiguration;
import de.mossgrabers.controller.yaeltex.turn.controller.YaeltexTurnPadGrid;
import de.mossgrabers.framework.controller.AbstractControlSurface;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.hardware.BindType;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.IMidiInput;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import java.util.Arrays;

public class YaeltexTurnControlSurface
extends AbstractControlSurface<YaeltexTurnConfiguration> {
    public static final int MIDI_CHANNEL_MAIN = 15;
    public static final int MIDI_CHANNEL_SET_COLOR = 13;
    public static final int MIDI_CHANNEL_SET_INTENSITY = 12;
    public static final int BUTTON_CLIPS = 8;
    public static final int BUTTON_USR = 9;
    public static final int BUTTON_PLAY = 10;
    public static final int BUTTON_REC = 11;
    public static final int BUTTON_LOOP = 12;
    public static final int BUTTON_LEFT = 13;
    public static final int BUTTON_SELECT = 14;
    public static final int BUTTON_SHIFT = 15;
    public static final int BUTTON_SESSION = 0;
    public static final int BUTTON_TRK = 1;
    public static final int BUTTON_STOP = 2;
    public static final int BUTTON_OVERDUB = 3;
    public static final int BUTTON_TAP_TEMPO = 4;
    public static final int BUTTON_RIGHT = 5;
    public static final int BUTTON_UP = 6;
    public static final int BUTTON_DOWN = 7;
    public static final int BUTTON_ROW1_1 = 70;
    public static final int BUTTON_ROW2_1 = 86;
    public static final int BUTTON_ROW3_1 = 102;
    public static final int BUTTON_ROW4_1 = 110;
    public static final int KNOB_DIGITAL_ROW1 = 0;
    public static final int KNOB_ANALOG_ROW1 = 32;
    public static final int FADER1 = 64;
    public static final int KNOB_ANALOG_TEMPO = 72;
    public static final int KNOB_ANALOG_A_B = 73;
    public static final int KNOB_ANALOG_CUE = 74;
    public static final int KNOB_ANALOG_MASTER = 75;
    private final int[] knobCache = new int[128];
    private final int[] knobColorCache = new int[128];

    public YaeltexTurnControlSurface(IHost host, ColorManager colorManager, YaeltexTurnConfiguration configuration, IMidiOutput output, IMidiInput input) {
        super(host, configuration, colorManager, output, input, new YaeltexTurnPadGrid(colorManager, output), 700.0, 860.0);
        this.defaultMidiChannel = 15;
        Arrays.fill(this.knobCache, -1);
        Arrays.fill(this.knobColorCache, -1);
    }

    @Override
    protected void flushHardware() {
        super.flushHardware();
        ((YaeltexTurnPadGrid)this.padGrid).flush();
    }

    public void setLED(int knob, int value, int color) {
        if (this.knobCache[knob] != value) {
            this.knobCache[knob] = value;
            this.output.sendCCEx(15, knob, value);
        }
        if (this.knobColorCache[knob] != color) {
            this.knobColorCache[knob] = color;
            this.output.sendCCEx(13, knob, color);
        }
    }

    @Override
    protected void internalShutdown() {
        super.internalShutdown();
        for (int i = 0; i < 32; ++i) {
            this.setLED(0 + i, 0, 0);
        }
    }

    @Override
    public void setTrigger(BindType bindType, int channel, int cc, int value) {
        if (bindType == BindType.CC || channel != 15) {
            super.setTrigger(bindType, channel, cc, value);
        } else {
            boolean isLow = value >= 128;
            this.output.sendNoteEx(15, cc, isLow ? value - 128 : value);
            this.output.sendNoteEx(12, cc, isLow ? 0 : 127);
        }
    }
}

