/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.osc;

import de.mossgrabers.framework.configuration.IActionSetting;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.IIntegerSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.configuration.IStringSetting;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import de.mossgrabers.framework.osc.AbstractOpenSoundControlConfiguration;
import java.util.Arrays;
import java.util.List;

public class OSCConfiguration
extends AbstractOpenSoundControlConfiguration {
    private static final String CATEGORY_SETUP = "Setup";
    public static final Integer RECEIVE_PORT = 103;
    public static final Integer VALUE_RESOLUTION = 104;
    public static final int NUM_ASSIGNABLE_ACTIONS = 20;
    private static final String CATEGORY_PROTOCOL = "Protocol (must match your client template!)";
    private static final String[] VALUE_RESOLUTION_OPTIONS = new String[]{"Low (128)", "Medium (1024)", "High (16384)"};
    private int receivePort = 8000;
    private String sendHost = "127.0.0.1";
    private int sendPort = 9000;
    private ValueResolution valueResolution = ValueResolution.LOW;
    private int bankPageSize = 8;
    private final String[] assignableFunctionActions = new String[20];

    public OSCConfiguration(IHost host, IValueChanger valueChanger, List<ArpeggiatorMode> arpeggiatorModes) {
        super(host, valueChanger, arpeggiatorModes);
        Arrays.fill(this.assignableFunctionActions, "");
    }

    @Override
    public void init(ISettingsUI globalSettings, ISettingsUI documentSettings) {
        IIntegerSetting receivePortSetting = globalSettings.getRangeSetting("Port to receive on", CATEGORY_SETUP, 1024, 65535, 1, "", 8000);
        receivePortSetting.addValueObserver(value -> {
            this.receivePort = value;
            this.notifyObservers(RECEIVE_PORT);
        });
        this.isSettingActive.add(RECEIVE_PORT);
        IStringSetting sendHostSetting = globalSettings.getStringSetting("Host to send to (requires restart)", CATEGORY_SETUP, 15, "127.0.0.1");
        this.sendHost = (String)sendHostSetting.get();
        IIntegerSetting sendPortSetting = globalSettings.getRangeSetting("Port to send to (requires restart)", CATEGORY_SETUP, 1024, 65535, 1, "", 9000);
        this.sendPort = (Integer)sendPortSetting.get();
        IEnumSetting valueResolutionSetting = globalSettings.getEnumSetting("Value resolution", CATEGORY_PROTOCOL, VALUE_RESOLUTION_OPTIONS, VALUE_RESOLUTION_OPTIONS[0]);
        valueResolutionSetting.addValueObserver(value -> {
            if (VALUE_RESOLUTION_OPTIONS[0].equals(value)) {
                this.valueResolution = ValueResolution.LOW;
            } else if (VALUE_RESOLUTION_OPTIONS[1].equals(value)) {
                this.valueResolution = ValueResolution.MEDIUM;
            } else if (VALUE_RESOLUTION_OPTIONS[2].equals(value)) {
                this.valueResolution = ValueResolution.HIGH;
            }
            this.notifyObservers(VALUE_RESOLUTION);
        });
        this.isSettingActive.add(VALUE_RESOLUTION);
        String[] pageSize = new String[200];
        for (int i = 0; i < pageSize.length; ++i) {
            pageSize[i] = Integer.toString(i + 1);
        }
        IEnumSetting bankPageSizeSetting = globalSettings.getEnumSetting("Bank Page Size (requires restart)", CATEGORY_PROTOCOL, pageSize, pageSize[7]);
        this.bankPageSize = Integer.parseInt((String)bankPageSizeSetting.get());
        this.activateBehaviourOnStopSetting(globalSettings);
        this.activateTrackNavigationSetting(globalSettings, null, true);
        this.activateAccentActiveSetting(globalSettings);
        this.activateAccentValueSetting(globalSettings);
        this.activateExcludeDeactivatedItemsSetting(globalSettings);
        this.activateEnableVUMetersSetting(globalSettings);
        for (int i = 0; i < this.assignableFunctionActions.length; ++i) {
            int pos = i;
            IActionSetting actionSetting = globalSettings.getActionSetting("Action " + (i + 1), "Actions");
            actionSetting.addValueObserver(value -> {
                this.assignableFunctionActions[pos] = (String)actionSetting.get();
            });
        }
        this.activateOSCLogging(globalSettings);
    }

    public int getReceivePort() {
        return this.receivePort;
    }

    public String getSendHost() {
        return this.sendHost;
    }

    public int getSendPort() {
        return this.sendPort;
    }

    public ValueResolution getValueResolution() {
        return this.valueResolution;
    }

    public int getBankPageSize() {
        return this.bankPageSize;
    }

    public String getAssignableAction(int index) {
        return this.assignableFunctionActions[index];
    }

    public static enum ValueResolution {
        LOW,
        MEDIUM,
        HIGH;

    }
}

