/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.sl.mode;

import de.mossgrabers.controller.novation.sl.SLConfiguration;
import de.mossgrabers.controller.novation.sl.controller.SLControlSurface;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.mode.track.DefaultTrackMode;

public class TrackTogglesMode
extends DefaultTrackMode<SLControlSurface, SLConfiguration> {
    private static final String OFF = "   Off";
    private static final String ON = "   On";

    public TrackTogglesMode(SLControlSurface surface, IModel model) {
        super("Track", surface, model, true);
    }

    @Override
    public void updateDisplay() {
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        ITextDisplay d = ((SLControlSurface)this.surface).getTextDisplay().clearRow(0).clearRow(1);
        if (!cursorTrack.doesExist()) {
            d.setRow(0, "                        Please select a track...                       ").done(0).done(1);
            return;
        }
        ICursorDevice device = this.model.getCursorDevice();
        d.setCell(0, 0, "  Mute");
        d.setCell(1, 0, cursorTrack.isMute() ? ON : OFF);
        d.setCell(0, 1, "  Solo");
        d.setCell(1, 1, cursorTrack.isSolo() ? ON : OFF);
        d.setCell(0, 2, "Rec Arm");
        d.setCell(1, 2, cursorTrack.isRecArm() ? ON : OFF);
        d.setCell(0, 3, " Write");
        d.setCell(1, 3, this.model.getTransport().isWritingArrangerAutomation() ? ON : OFF);
        d.setCell(0, 4, " Browse");
        d.setCell(1, 4, "");
        d.setCell(0, 5, device.doesExist() ? device.getName(8) : "None");
        d.setCell(1, 5, device.isEnabled() ? "Enabled" : "Disabled");
        d.setCell(0, 6, "<<Device").setCell(2, 6, "");
        d.setCell(0, 7, "Device>>").setCell(2, 7, "").done(0).done(2);
        d.done(0).done(1);
    }
}

