/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchpad.view;

import de.mossgrabers.controller.novation.launchpad.controller.LaunchpadControlSurface;
import de.mossgrabers.controller.novation.launchpad.view.PlayView;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.ScrollStates;
import de.mossgrabers.framework.view.PianoViewHelper;

public class PianoView
extends PlayView {
    public PianoView(LaunchpadControlSurface surface, IModel model) {
        super("Piano", surface, model);
    }

    @Override
    public void drawGrid() {
        PianoViewHelper.drawGrid(((LaunchpadControlSurface)this.surface).getPadGrid(), this.model, this.keyManager);
    }

    @Override
    public void onOctaveDown(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        this.keyManager.clearPressedKeys();
        this.scales.decPianoOctave();
        this.updateNoteMapping();
        ((LaunchpadControlSurface)this.surface).getDisplay().notify(this.scales.getPianoRangeText());
    }

    @Override
    public void onOctaveUp(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        this.keyManager.clearPressedKeys();
        this.scales.incPianoOctave();
        this.updateNoteMapping();
        ((LaunchpadControlSurface)this.surface).getDisplay().notify(this.scales.getPianoRangeText());
    }

    @Override
    public void updateNoteMapping() {
        this.delayedUpdateNoteMapping(this.model.canSelectedTrackHoldNotes() ? this.scales.getPianoMatrix(8, 8) : EMPTY_TABLE);
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        return 0;
    }

    @Override
    public void updateScrollStates(ScrollStates scrollStates) {
        int pianoOctave = this.scales.getPianoOctave();
        scrollStates.setCanScrollLeft(false);
        scrollStates.setCanScrollRight(false);
        scrollStates.setCanScrollUp(pianoOctave < 3);
        scrollStates.setCanScrollDown(pianoOctave > -3);
    }
}

