/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3.view;

import de.mossgrabers.controller.ni.maschine.core.MaschineColorManager;
import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.controller.ni.maschine.mk3.view.BaseView;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.mode.device.SelectedDeviceMode;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.Optional;

public class ParameterView
extends BaseView {
    public ParameterView(MaschineControlSurface surface, IModel model) {
        super("Parameter", surface, model);
    }

    @Override
    public void executeFunction(int padIndex, ButtonEvent buttonEvent) {
        if (buttonEvent != ButtonEvent.DOWN) {
            return;
        }
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        IHost host = this.model.getHost();
        if (!cursorDevice.doesExist()) {
            host.showNotification("No device selected.");
            return;
        }
        switch (padIndex) {
            case 12: {
                cursorDevice.selectPrevious();
                break;
            }
            case 13: {
                cursorDevice.selectNext();
                break;
            }
            case 14: {
                cursorDevice.getParameterBank().scrollBackwards();
                this.mvHelper.notifySelectedParameterPage();
                break;
            }
            case 15: {
                cursorDevice.getParameterBank().scrollForwards();
                this.mvHelper.notifySelectedParameterPage();
                break;
            }
        }
        if (padIndex >= 8) {
            return;
        }
        int selectedParameter = padIndex < 4 ? padIndex + 4 : padIndex - 4;
        ((SelectedDeviceMode)((MaschineControlSurface)this.surface).getModeManager().get(Modes.DEVICE_PARAMS)).selectParameter(selectedParameter);
        this.model.getHost().scheduleTask(() -> {
            IParameterBank parameterBank = cursorDevice.getParameterBank();
            StringBuilder message = new StringBuilder();
            Optional selectedPage = parameterBank.getPageBank().getSelectedItem();
            if (selectedPage.isEmpty()) {
                message.append("No parameters available.");
            } else {
                message.append((String)selectedPage.get()).append(": ");
                IParameter item = (IParameter)parameterBank.getItem(selectedParameter);
                if (item.doesExist()) {
                    message.append(item.getName());
                } else {
                    message.append("None");
                }
            }
            host.showNotification(message.toString());
        }, 200L);
    }

    @Override
    public void drawGrid() {
        IPadGrid padGrid = ((MaschineControlSurface)this.surface).getPadGrid();
        for (int i = 8; i < 12; ++i) {
            padGrid.lightEx(i % 4, 3 - i / 4, "BUTTON_COLOR_OFF");
        }
        ICursorDevice cursorDevice = this.model.getCursorDevice();
        boolean doesExist = cursorDevice.doesExist();
        padGrid.lightEx(0, 0, doesExist && cursorDevice.canSelectPrevious() ? 7 : 0);
        padGrid.lightEx(1, 0, doesExist && cursorDevice.canSelectNext() ? 7 : 0);
        IParameterBank parameterBank = cursorDevice.getParameterBank();
        padGrid.lightEx(2, 0, doesExist && parameterBank.canScrollBackwards() ? 11 : 0);
        padGrid.lightEx(3, 0, doesExist && parameterBank.canScrollForwards() ? 11 : 0);
        SelectedDeviceMode deviceMode = (SelectedDeviceMode)((MaschineControlSurface)this.surface).getModeManager().get(Modes.DEVICE_PARAMS);
        for (int i = 0; i < 8; ++i) {
            int x = i % 4;
            int y = 2 + i / 4;
            IParameter item = (IParameter)parameterBank.getItem(i);
            if (item.doesExist()) {
                int color = MaschineColorManager.PARAM_COLORS.get(i);
                if (i == deviceMode.getSelectedParameter()) {
                    padGrid.lightEx(x, y, color, 78, false);
                    continue;
                }
                padGrid.lightEx(x, y, color);
                continue;
            }
            padGrid.lightEx(x, y, "BUTTON_COLOR_OFF");
        }
    }
}

