/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.hardware;

import de.mossgrabers.framework.controller.hardware.AbstractHwControl;
import de.mossgrabers.framework.controller.hardware.IHwGraphicsDisplay;
import de.mossgrabers.framework.graphics.IBitmap;
import de.mossgrabers.framework.graphics.IGraphicsContext;
import de.mossgrabers.reaper.framework.graphics.BitmapImpl;
import de.mossgrabers.reaper.framework.graphics.GraphicsContextImpl;
import de.mossgrabers.reaper.framework.hardware.Bounds;
import de.mossgrabers.reaper.framework.hardware.HwControlLayout;
import de.mossgrabers.reaper.framework.hardware.IReaperHwControl;

public class HwGraphicsDisplayImpl
extends AbstractHwControl
implements IHwGraphicsDisplay,
IReaperHwControl {
    private final HwControlLayout layout;
    private final IBitmap bitmap;

    public HwGraphicsDisplayImpl(String id, IBitmap bitmap) {
        super(null, null);
        this.bitmap = bitmap;
        this.layout = new HwControlLayout(id);
    }

    @Override
    public void setBounds(double x, double y, double width, double height) {
        this.layout.setBounds(x, y, width, height);
    }

    @Override
    public void draw(IGraphicsContext gc, double scale) {
        Bounds bounds = this.layout.getBounds();
        if (bounds == null) {
            return;
        }
        ((BitmapImpl)this.bitmap).drawScaledImage(((GraphicsContextImpl)gc).getGraphics(), (int)(bounds.x() * scale), (int)(bounds.y() * scale), (int)(bounds.width() * scale), (int)(bounds.height() * scale));
    }

    @Override
    public void mouse(int mouseEvent, double x, double y, double scale) {
    }
}

