/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.controller;

import com.nikhaldimann.inieditor.IniEditor;
import de.mossgrabers.framework.controller.IControllerDefinition;
import de.mossgrabers.framework.controller.IControllerSetup;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.reaper.communication.BackendExchange;
import de.mossgrabers.reaper.controller.IControllerInstance;
import de.mossgrabers.reaper.controller.ableton.push.Push1ControllerInstance;
import de.mossgrabers.reaper.controller.ableton.push.Push2ControllerInstance;
import de.mossgrabers.reaper.controller.ableton.push.Push3ControllerInstance;
import de.mossgrabers.reaper.controller.akai.acvs.ACVSLiveControllerInstance;
import de.mossgrabers.reaper.controller.akai.apc.APC40mkIControllerInstance;
import de.mossgrabers.reaper.controller.akai.apc.APC40mkIIControllerInstance;
import de.mossgrabers.reaper.controller.akai.apcmini.APCminiMk1ControllerInstance;
import de.mossgrabers.reaper.controller.akai.apcmini.APCminiMk2ControllerInstance;
import de.mossgrabers.reaper.controller.akai.fire.FireControllerInstance;
import de.mossgrabers.reaper.controller.arturia.beatstep.BeatstepControllerInstance;
import de.mossgrabers.reaper.controller.electra.one.ElectraOneControllerInstance;
import de.mossgrabers.reaper.controller.esi.xjam.XjamControllerInstance;
import de.mossgrabers.reaper.controller.faderfox.ec4.EC4ControllerInstance;
import de.mossgrabers.reaper.controller.gamepad.GamepadControllerInstance;
import de.mossgrabers.reaper.controller.generic.GenericFlexiControllerInstance;
import de.mossgrabers.reaper.controller.intuitiveinstruments.exquis.ExquisControllerInstance;
import de.mossgrabers.reaper.controller.mackie.hui.HUI1ControllerInstance;
import de.mossgrabers.reaper.controller.mackie.hui.HUI2ControllerInstance;
import de.mossgrabers.reaper.controller.mackie.hui.HUI3ControllerInstance;
import de.mossgrabers.reaper.controller.mackie.mcu.MCU1ControllerInstance;
import de.mossgrabers.reaper.controller.mackie.mcu.MCU2ControllerInstance;
import de.mossgrabers.reaper.controller.mackie.mcu.MCU3ControllerInstance;
import de.mossgrabers.reaper.controller.mackie.mcu.MCU4ControllerInstance;
import de.mossgrabers.reaper.controller.ni.kontrol.mki.KontrolMkIS25ControllerInstance;
import de.mossgrabers.reaper.controller.ni.kontrol.mki.KontrolMkIS49ControllerInstance;
import de.mossgrabers.reaper.controller.ni.kontrol.mki.KontrolMkIS61ControllerInstance;
import de.mossgrabers.reaper.controller.ni.kontrol.mki.KontrolMkIS88ControllerInstance;
import de.mossgrabers.reaper.controller.ni.kontrol.mkii.KontrolProtocolV1ControllerInstance;
import de.mossgrabers.reaper.controller.ni.kontrol.mkii.KontrolProtocolV2ControllerInstance;
import de.mossgrabers.reaper.controller.ni.kontrol.mkii.KontrolProtocolV3ControllerInstance;
import de.mossgrabers.reaper.controller.ni.maschine.jam.MaschineJamControllerInstance;
import de.mossgrabers.reaper.controller.ni.maschine.mk3.MaschineMikroMk3ControllerInstance;
import de.mossgrabers.reaper.controller.ni.maschine.mk3.MaschineMk2ControllerInstance;
import de.mossgrabers.reaper.controller.ni.maschine.mk3.MaschineMk3ControllerInstance;
import de.mossgrabers.reaper.controller.ni.maschine.mk3.MaschinePlusControllerInstance;
import de.mossgrabers.reaper.controller.ni.maschine.mk3.MaschineStudioControllerInstance;
import de.mossgrabers.reaper.controller.novation.launchcontrol.LaunchControlXLControllerInstance;
import de.mossgrabers.reaper.controller.novation.launchkey.LaunchkeyMiniMk3ControllerInstance;
import de.mossgrabers.reaper.controller.novation.launchkey.LaunchkeyMk3ControllerInstance;
import de.mossgrabers.reaper.controller.novation.launchpad.LaunchpadMiniMkIIIControllerInstance;
import de.mossgrabers.reaper.controller.novation.launchpad.LaunchpadMkIIControllerInstance;
import de.mossgrabers.reaper.controller.novation.launchpad.LaunchpadProControllerInstance;
import de.mossgrabers.reaper.controller.novation.launchpad.LaunchpadProMk3ControllerInstance;
import de.mossgrabers.reaper.controller.novation.launchpad.LaunchpadXControllerInstance;
import de.mossgrabers.reaper.controller.novation.sl.SLMkIControllerInstance;
import de.mossgrabers.reaper.controller.novation.sl.SLMkIIControllerInstance;
import de.mossgrabers.reaper.controller.novation.slmkiii.SLMkIIIControllerInstance;
import de.mossgrabers.reaper.controller.osc.OSCControllerInstance;
import de.mossgrabers.reaper.controller.oxi.OxiOneControllerInstance;
import de.mossgrabers.reaper.controller.utilities.autocolor.AutoColorInstance;
import de.mossgrabers.reaper.controller.utilities.midimonitor.MidiMonitorInstance;
import de.mossgrabers.reaper.controller.yaeltex.turn.YaeltexTurnControllerInstance;
import de.mossgrabers.reaper.framework.IniFiles;
import de.mossgrabers.reaper.framework.configuration.GlobalSettingsUI;
import de.mossgrabers.reaper.framework.daw.data.CursorDeviceImpl;
import de.mossgrabers.reaper.framework.daw.data.parameter.map.ParameterMap;
import de.mossgrabers.reaper.framework.daw.data.parameter.map.ParameterMapPage;
import de.mossgrabers.reaper.framework.daw.data.parameter.map.ParameterMapPageParameter;
import de.mossgrabers.reaper.framework.device.DeviceManager;
import de.mossgrabers.reaper.framework.midi.MidiAccessImpl;
import de.mossgrabers.reaper.ui.WindowManager;
import de.mossgrabers.reaper.ui.dialog.ParameterMappingDialog;
import de.mossgrabers.reaper.ui.dialog.ProjectSettingsDialog;
import de.mossgrabers.reaper.ui.utils.LogModel;
import de.mossgrabers.reaper.ui.utils.PropertiesEx;
import de.mossgrabers.reaper.ui.widget.Functions;
import java.awt.Window;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.sound.midi.MidiDevice;

public class ControllerInstanceManager {
    private static final String CONTROLLER_INSTANCE_TAG = "CONTROLLER_INSTANCE";
    private static final Map<IControllerDefinition, Class<?>> DEF_TO_CLASS = new HashMap();
    private static final Map<String, Class<?>> NAME_TO_CLASS = new HashMap();
    private static final Class<?>[] CONSTRUCTOR_TYPES;
    private final List<IControllerInstance> instances = new ArrayList<IControllerInstance>();
    private final LogModel logModel;
    private final WindowManager windowManager;
    private final BackendExchange sender;
    private final IniFiles iniFiles;
    private final int majorVersion;
    private final int minorVersion;

    public ControllerInstanceManager(LogModel logModel, WindowManager windowManager, BackendExchange sender, IniFiles iniFiles, int majorVersion, int minorVersion) {
        this.logModel = logModel;
        this.windowManager = windowManager;
        this.sender = sender;
        this.iniFiles = iniFiles;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public Set<IControllerDefinition> getDefinitions() {
        return DEF_TO_CLASS.keySet();
    }

    public void startAll() {
        this.instances.forEach(IControllerInstance::start);
    }

    public void stopAll() {
        this.instances.forEach(IControllerInstance::stop);
    }

    public void refreshMIDIAll() {
        MidiAccessImpl.readDeviceMetadata();
        this.instances.forEach(IControllerInstance::restart);
    }

    public boolean areRunning() {
        for (IControllerInstance inst : this.instances) {
            if (inst.isRunning()) continue;
            return false;
        }
        return true;
    }

    public void flushAll() {
        this.instances.forEach(IControllerInstance::flush);
    }

    public void parseAll(String address, String argument) {
        this.instances.forEach(inst -> {
            try {
                if (inst.isEnabled()) {
                    inst.parse(address, argument);
                }
            }
            catch (RuntimeException ex) {
                StringBuilder sb = new StringBuilder("Could not parse OSC message: ").append(address).append(" ");
                if (argument != null) {
                    sb.append(argument);
                }
                this.logModel.error(sb.toString(), ex);
            }
        });
    }

    public void edit(int index) {
        this.instances.get(index).edit();
    }

    public void projectSettings() {
        new ProjectSettingsDialog((Window)this.windowManager.getMainFrame(), this.instances).showDialog();
    }

    public void remove(int index) {
        IControllerInstance controllerInstance = this.instances.remove(index);
        if (controllerInstance != null) {
            controllerInstance.stop();
        }
    }

    public void parameterSettings(int index) {
        IControllerInstance controllerInstance = this.instances.get(index);
        if (controllerInstance == null) {
            return;
        }
        IControllerSetup<?, ?> controllerSetup = controllerInstance.getControllerSetup();
        if (controllerSetup == null) {
            Functions.message("The controller '" + controllerInstance.getDefinition().toString() + "' is currently not running.", new String[0]);
            return;
        }
        ICursorDevice cursorDevice = controllerSetup.getModel().getCursorDevice();
        if (!cursorDevice.doesExist()) {
            Functions.message("Please select the device to edit on the controller: " + controllerInstance.getDefinition().toString(), new String[0]);
            return;
        }
        Map<String, ParameterMap> parameterMaps = DeviceManager.get().getParameterMaps();
        String name = cursorDevice.getName().toLowerCase();
        ParameterMap pm = parameterMaps.computeIfAbsent(name, n -> new ParameterMap(cursorDevice));
        ParameterMappingDialog dialog = new ParameterMappingDialog((Window)this.windowManager.getMainFrame(), cursorDevice, pm);
        dialog.showDialog();
        if (dialog.isConfirmed()) {
            if (pm.getPages().isEmpty()) {
                parameterMaps.remove(name);
            }
            this.storeDeviceParameterMapping(pm);
        }
    }

    private void storeDeviceParameterMapping(ParameterMap parameterMap) {
        IniEditor iniParamMaps = this.iniFiles.getIniParamMaps();
        String name = parameterMap.getDeviceName();
        iniParamMaps.removeSection(name);
        List<ParameterMapPage> pages = parameterMap.getPages();
        if (!pages.isEmpty()) {
            iniParamMaps.addSection(name);
            for (int i = 0; i < pages.size(); ++i) {
                ParameterMapPage page = pages.get(i);
                StringBuilder sb = new StringBuilder();
                for (ParameterMapPageParameter parameter : page.getParameters()) {
                    if (!sb.isEmpty()) {
                        sb.append(',');
                    }
                    sb.append(parameter.getIndex()).append(',');
                    String paramName = parameter.getName();
                    if (paramName == null || paramName.isBlank()) {
                        paramName = "Not assigned";
                    }
                    sb.append(paramName);
                }
                iniParamMaps.set(name, "page" + i, page.getName());
                iniParamMaps.set(name, "params" + i, sb.toString());
            }
        }
        try {
            this.iniFiles.storeIniParamMaps();
        }
        catch (IOException ex) {
            this.logModel.error("Could not store device mappings file.", ex);
        }
        this.refreshDeviceMappings();
    }

    private void refreshDeviceMappings() {
        for (IControllerInstance instance : this.instances) {
            ICursorDevice cursorDevice;
            IControllerSetup<?, ?> controllerSetup = instance.getControllerSetup();
            if (controllerSetup == null || !(cursorDevice = controllerSetup.getModel().getCursorDevice()).doesExist() || !(cursorDevice instanceof CursorDeviceImpl)) continue;
            CursorDeviceImpl deviceImpl = (CursorDeviceImpl)cursorDevice;
            deviceImpl.refreshParameterMapping();
        }
    }

    public IControllerInstance instantiate(IControllerDefinition definition) {
        return this.instantiateController(DEF_TO_CLASS.get(definition));
    }

    public boolean isInstantiated(IControllerDefinition definition) {
        for (IControllerInstance inst : this.instances) {
            if (!inst.getDefinition().equals(definition)) continue;
            return true;
        }
        return false;
    }

    public boolean areInUse(List<MidiDevice> inputDevices, List<MidiDevice> outputDevices) {
        for (IControllerInstance inst : this.instances) {
            GlobalSettingsUI settings = inst.getGlobalSettingsUI();
            for (MidiDevice input : settings.getSelectedMidiInputs()) {
                if (!inputDevices.contains(input)) continue;
                return true;
            }
            for (MidiDevice output : settings.getSelectedMidiOutputs()) {
                if (!inputDevices.contains(output)) continue;
                return true;
            }
        }
        return false;
    }

    public List<IControllerInstance> getInstances() {
        return new ArrayList<IControllerInstance>(this.instances);
    }

    public void load(PropertiesEx properties) {
        String clazz;
        TreeSet<String> classNames = new TreeSet<String>();
        int counter = 0;
        String foundDuplicate = null;
        while ((clazz = properties.getString(CONTROLLER_INSTANCE_TAG + counter)) != null) {
            if (classNames.contains(clazz)) {
                foundDuplicate = clazz;
            } else {
                classNames.add(clazz);
            }
            ++counter;
        }
        for (String className : classNames) {
            Class<?> controllerClass = NAME_TO_CLASS.get(className);
            if (controllerClass == null) {
                this.logModel.info("Unknown controller class: " + className);
                continue;
            }
            this.instantiateController(controllerClass);
        }
        if (foundDuplicate != null) {
            this.logModel.error("Found duplicate controller class in configuration file: " + foundDuplicate + ". Fixing and resaving the file.", null);
            this.save(properties);
        }
    }

    public void save(PropertiesEx properties) {
        ArrayList<String> oldEntries = new ArrayList<String>();
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            Object object = e.getKey();
            if (!(object instanceof String)) continue;
            String key = (String)object;
            oldEntries.add(key);
        }
        for (String key : oldEntries) {
            properties.remove(key);
        }
        TreeSet<String> classNames = new TreeSet<String>();
        int counter = 0;
        for (IControllerInstance inst : this.instances) {
            String clazz = inst.getClass().getName();
            if (classNames.contains(clazz)) continue;
            properties.putString(CONTROLLER_INSTANCE_TAG + counter, clazz);
            classNames.add(clazz);
            ++counter;
        }
    }

    private IControllerInstance instantiateController(Class<?> clazz) {
        try {
            Constructor<?> constructor = clazz.getConstructor(CONSTRUCTOR_TYPES);
            IControllerInstance newInstance = (IControllerInstance)constructor.newInstance(this.logModel, this.windowManager, this.sender, this.iniFiles);
            newInstance.setHostVersion(this.majorVersion, this.minorVersion);
            this.instances.add(newInstance);
            return newInstance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            this.logModel.error("Could not instantiate controller class: " + clazz.getName() + ".", ex);
            return null;
        }
    }

    static {
        DEF_TO_CLASS.put(AutoColorInstance.CONTROLLER_DEFINITION, AutoColorInstance.class);
        DEF_TO_CLASS.put(APC40mkIControllerInstance.CONTROLLER_DEFINITION, APC40mkIControllerInstance.class);
        DEF_TO_CLASS.put(APC40mkIIControllerInstance.CONTROLLER_DEFINITION, APC40mkIIControllerInstance.class);
        DEF_TO_CLASS.put(APCminiMk1ControllerInstance.CONTROLLER_DEFINITION, APCminiMk1ControllerInstance.class);
        DEF_TO_CLASS.put(APCminiMk2ControllerInstance.CONTROLLER_DEFINITION, APCminiMk2ControllerInstance.class);
        DEF_TO_CLASS.put(BeatstepControllerInstance.CONTROLLER_DEFINITION, BeatstepControllerInstance.class);
        DEF_TO_CLASS.put(ElectraOneControllerInstance.CONTROLLER_DEFINITION, ElectraOneControllerInstance.class);
        DEF_TO_CLASS.put(ExquisControllerInstance.CONTROLLER_DEFINITION, ExquisControllerInstance.class);
        DEF_TO_CLASS.put(FireControllerInstance.CONTROLLER_DEFINITION, FireControllerInstance.class);
        DEF_TO_CLASS.put(EC4ControllerInstance.CONTROLLER_DEFINITION, EC4ControllerInstance.class);
        DEF_TO_CLASS.put(GamepadControllerInstance.CONTROLLER_DEFINITION, GamepadControllerInstance.class);
        DEF_TO_CLASS.put(GenericFlexiControllerInstance.CONTROLLER_DEFINITION, GenericFlexiControllerInstance.class);
        DEF_TO_CLASS.put(HUI1ControllerInstance.CONTROLLER_DEFINITION, HUI1ControllerInstance.class);
        DEF_TO_CLASS.put(HUI2ControllerInstance.CONTROLLER_DEFINITION, HUI2ControllerInstance.class);
        DEF_TO_CLASS.put(HUI3ControllerInstance.CONTROLLER_DEFINITION, HUI3ControllerInstance.class);
        DEF_TO_CLASS.put(KontrolMkIS25ControllerInstance.CONTROLLER_DEFINITION, KontrolMkIS25ControllerInstance.class);
        DEF_TO_CLASS.put(KontrolMkIS49ControllerInstance.CONTROLLER_DEFINITION, KontrolMkIS49ControllerInstance.class);
        DEF_TO_CLASS.put(KontrolMkIS61ControllerInstance.CONTROLLER_DEFINITION, KontrolMkIS61ControllerInstance.class);
        DEF_TO_CLASS.put(KontrolMkIS88ControllerInstance.CONTROLLER_DEFINITION, KontrolMkIS88ControllerInstance.class);
        DEF_TO_CLASS.put(KontrolProtocolV1ControllerInstance.CONTROLLER_DEFINITION, KontrolProtocolV1ControllerInstance.class);
        DEF_TO_CLASS.put(KontrolProtocolV2ControllerInstance.CONTROLLER_DEFINITION, KontrolProtocolV2ControllerInstance.class);
        DEF_TO_CLASS.put(KontrolProtocolV3ControllerInstance.CONTROLLER_DEFINITION, KontrolProtocolV3ControllerInstance.class);
        DEF_TO_CLASS.put(LaunchControlXLControllerInstance.CONTROLLER_DEFINITION, LaunchControlXLControllerInstance.class);
        DEF_TO_CLASS.put(LaunchkeyMiniMk3ControllerInstance.CONTROLLER_DEFINITION, LaunchkeyMiniMk3ControllerInstance.class);
        DEF_TO_CLASS.put(LaunchkeyMk3ControllerInstance.CONTROLLER_DEFINITION, LaunchkeyMk3ControllerInstance.class);
        DEF_TO_CLASS.put(LaunchpadMkIIControllerInstance.CONTROLLER_DEFINITION, LaunchpadMkIIControllerInstance.class);
        DEF_TO_CLASS.put(LaunchpadProControllerInstance.CONTROLLER_DEFINITION, LaunchpadProControllerInstance.class);
        DEF_TO_CLASS.put(LaunchpadXControllerInstance.CONTROLLER_DEFINITION, LaunchpadXControllerInstance.class);
        DEF_TO_CLASS.put(LaunchpadMiniMkIIIControllerInstance.CONTROLLER_DEFINITION, LaunchpadMiniMkIIIControllerInstance.class);
        DEF_TO_CLASS.put(LaunchpadProMk3ControllerInstance.CONTROLLER_DEFINITION, LaunchpadProMk3ControllerInstance.class);
        DEF_TO_CLASS.put(MaschineMikroMk3ControllerInstance.CONTROLLER_DEFINITION, MaschineMikroMk3ControllerInstance.class);
        DEF_TO_CLASS.put(MaschineMk2ControllerInstance.CONTROLLER_DEFINITION, MaschineMk2ControllerInstance.class);
        DEF_TO_CLASS.put(MaschineMk3ControllerInstance.CONTROLLER_DEFINITION, MaschineMk3ControllerInstance.class);
        DEF_TO_CLASS.put(MaschinePlusControllerInstance.CONTROLLER_DEFINITION, MaschinePlusControllerInstance.class);
        DEF_TO_CLASS.put(MaschineStudioControllerInstance.CONTROLLER_DEFINITION, MaschineStudioControllerInstance.class);
        DEF_TO_CLASS.put(MaschineJamControllerInstance.CONTROLLER_DEFINITION, MaschineJamControllerInstance.class);
        DEF_TO_CLASS.put(MidiMonitorInstance.CONTROLLER_DEFINITION, MidiMonitorInstance.class);
        DEF_TO_CLASS.put(MCU1ControllerInstance.CONTROLLER_DEFINITION, MCU1ControllerInstance.class);
        DEF_TO_CLASS.put(MCU2ControllerInstance.CONTROLLER_DEFINITION, MCU2ControllerInstance.class);
        DEF_TO_CLASS.put(MCU3ControllerInstance.CONTROLLER_DEFINITION, MCU3ControllerInstance.class);
        DEF_TO_CLASS.put(MCU4ControllerInstance.CONTROLLER_DEFINITION, MCU4ControllerInstance.class);
        DEF_TO_CLASS.put(ACVSLiveControllerInstance.CONTROLLER_DEFINITION, ACVSLiveControllerInstance.class);
        DEF_TO_CLASS.put(OSCControllerInstance.CONTROLLER_DEFINITION, OSCControllerInstance.class);
        DEF_TO_CLASS.put(OxiOneControllerInstance.CONTROLLER_DEFINITION, OxiOneControllerInstance.class);
        DEF_TO_CLASS.put(Push1ControllerInstance.CONTROLLER_DEFINITION, Push1ControllerInstance.class);
        DEF_TO_CLASS.put(Push2ControllerInstance.CONTROLLER_DEFINITION, Push2ControllerInstance.class);
        DEF_TO_CLASS.put(Push3ControllerInstance.CONTROLLER_DEFINITION, Push3ControllerInstance.class);
        DEF_TO_CLASS.put(SLMkIControllerInstance.CONTROLLER_DEFINITION, SLMkIControllerInstance.class);
        DEF_TO_CLASS.put(SLMkIIControllerInstance.CONTROLLER_DEFINITION, SLMkIIControllerInstance.class);
        DEF_TO_CLASS.put(SLMkIIIControllerInstance.CONTROLLER_DEFINITION, SLMkIIIControllerInstance.class);
        DEF_TO_CLASS.put(XjamControllerInstance.CONTROLLER_DEFINITION, XjamControllerInstance.class);
        DEF_TO_CLASS.put(YaeltexTurnControllerInstance.CONTROLLER_DEFINITION, YaeltexTurnControllerInstance.class);
        for (Class<?> clazz : DEF_TO_CLASS.values()) {
            NAME_TO_CLASS.put(clazz.getName(), clazz);
        }
        CONSTRUCTOR_TYPES = new Class[]{LogModel.class, WindowManager.class, BackendExchange.class, IniFiles.class};
    }
}

