/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.graphics.canvas.component;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.graphics.IBounds;
import de.mossgrabers.framework.graphics.IGraphicsConfiguration;
import de.mossgrabers.framework.graphics.IGraphicsContext;
import de.mossgrabers.framework.graphics.IGraphicsDimensions;
import de.mossgrabers.framework.graphics.IGraphicsInfo;
import de.mossgrabers.framework.graphics.canvas.component.IComponent;
import de.mossgrabers.framework.graphics.canvas.component.LabelComponent;

public class OptionsComponent
implements IComponent {
    private final LabelComponent header;
    private final LabelComponent footer;
    private final String headerTop;
    private final String headerBottom;
    private final boolean isBottomHeaderSelected;

    public OptionsComponent(String headerTop, String menuTopName, boolean isMenuTopSelected, ColorEx menuTopColor, String headerBottom, String menuBottomName, boolean isMenuBottomSelected, ColorEx menuBottomColor, boolean useSmallTopMenu, boolean isBottomHeaderSelected) {
        this.header = new LabelComponent(menuTopName, null, menuTopColor, isMenuTopSelected, true, useSmallTopMenu ? LabelComponent.LabelLayout.SMALL_HEADER : LabelComponent.LabelLayout.PLAIN);
        this.footer = new LabelComponent(menuBottomName, null, menuBottomColor, isMenuBottomSelected, true, LabelComponent.LabelLayout.PLAIN);
        this.headerTop = headerTop;
        this.headerBottom = headerBottom;
        this.isBottomHeaderSelected = isBottomHeaderSelected;
    }

    @Override
    public void draw(IGraphicsInfo info) {
        ColorEx borderColor;
        boolean hasBottomHeader;
        IGraphicsContext gc = info.getContext();
        IGraphicsDimensions dimensions = info.getDimensions();
        double menuHeight = 2.0 * dimensions.getMenuHeight();
        IGraphicsConfiguration configuration = info.getConfiguration();
        this.header.draw(info.withBounds(0.0, menuHeight));
        IBounds bounds = info.getBounds();
        double left = bounds.left();
        double height = bounds.height();
        this.footer.draw(info.withBounds(height - menuHeight, menuHeight));
        boolean hasTopHeader = this.headerTop != null && !this.headerTop.isEmpty();
        boolean bl = hasBottomHeader = this.headerBottom != null && !this.headerBottom.isEmpty();
        if (!hasTopHeader && !hasBottomHeader) {
            return;
        }
        double headerHeight = (height - 2.0 * menuHeight) / 2.0;
        ColorEx textColor = configuration.getColorText();
        if (textColor.equals(borderColor = configuration.getColorBorder())) {
            textColor = ColorEx.calcContrastColor(textColor);
        }
        if (hasTopHeader) {
            gc.drawTextInHeight(this.headerTop, left, menuHeight, headerHeight, textColor, headerHeight / 2.0);
        }
        if (hasBottomHeader) {
            if (this.isBottomHeaderSelected) {
                gc.drawTextInHeight(this.headerBottom, left, menuHeight + headerHeight, headerHeight, ColorEx.calcContrastColor(textColor), textColor, headerHeight / 2.0);
            } else {
                gc.drawTextInHeight(this.headerBottom, left, menuHeight + headerHeight, headerHeight, textColor, headerHeight / 2.0);
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.footer == null ? 0 : this.footer.hashCode());
        result = 31 * result + (this.header == null ? 0 : this.header.hashCode());
        result = 31 * result + (this.headerBottom == null ? 0 : this.headerBottom.hashCode());
        result = 31 * result + (this.headerTop == null ? 0 : this.headerTop.hashCode());
        result = 31 * result + (this.isBottomHeaderSelected ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OptionsComponent other = (OptionsComponent)obj;
        if (this.footer == null ? other.footer != null : !this.footer.equals(other.footer)) {
            return false;
        }
        if (this.header == null ? other.header != null : !this.header.equals(other.header)) {
            return false;
        }
        if (this.headerBottom == null ? other.headerBottom != null : !this.headerBottom.equals(other.headerBottom)) {
            return false;
        }
        if (this.headerTop == null ? other.headerTop != null : !this.headerTop.equals(other.headerTop)) {
            return false;
        }
        return this.isBottomHeaderSelected == other.isBottomHeaderSelected;
    }
}

