/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.daw.clip;

import de.mossgrabers.framework.daw.clip.IStepInfo;
import de.mossgrabers.framework.daw.clip.NoteOccurrenceType;
import de.mossgrabers.framework.daw.clip.StepState;
import de.mossgrabers.framework.daw.constants.Resolution;

public class DefaultStepInfo
implements IStepInfo {
    protected StepState state = StepState.OFF;
    protected double duration = Resolution.RES_1_16.getValue();
    protected double velocity;
    protected double velocitySpread;
    protected double releaseVelocity;
    protected double pressure;
    protected double timbre;
    protected double pan;
    protected double transpose;
    protected double gain;
    protected boolean isChanceEnabled;
    protected double chance;
    protected boolean isOccurrenceEnabled;
    protected NoteOccurrenceType occurrence;
    protected boolean isRecurrenceEnabled;
    protected int recurrenceLength;
    protected int recurrenceMask;
    protected boolean isRepeatEnabled;
    protected int repeatCount;
    protected double repeatCurve;
    protected double repeatVelocityCurve;
    protected double repeatVelocityEnd;
    protected boolean isMuted;
    protected boolean isSelected;

    public DefaultStepInfo() {
    }

    protected DefaultStepInfo(DefaultStepInfo sourceInfo) {
        this.state = sourceInfo.state;
        this.duration = sourceInfo.duration;
        this.velocity = sourceInfo.velocity;
        this.velocitySpread = sourceInfo.velocitySpread;
        this.releaseVelocity = sourceInfo.releaseVelocity;
        this.pressure = sourceInfo.pressure;
        this.timbre = sourceInfo.timbre;
        this.pan = sourceInfo.pan;
        this.transpose = sourceInfo.transpose;
        this.gain = sourceInfo.gain;
        this.isChanceEnabled = sourceInfo.isChanceEnabled;
        this.chance = sourceInfo.chance;
        this.isOccurrenceEnabled = sourceInfo.isOccurrenceEnabled;
        this.occurrence = sourceInfo.occurrence;
        this.isRecurrenceEnabled = sourceInfo.isRecurrenceEnabled;
        this.recurrenceLength = sourceInfo.recurrenceLength;
        this.recurrenceMask = sourceInfo.recurrenceMask;
        this.isRepeatEnabled = sourceInfo.isRepeatEnabled;
        this.repeatCount = sourceInfo.repeatCount;
        this.repeatCurve = sourceInfo.repeatCurve;
        this.repeatVelocityCurve = sourceInfo.repeatVelocityCurve;
        this.repeatVelocityEnd = sourceInfo.repeatVelocityEnd;
        this.isMuted = sourceInfo.isMuted;
        this.isSelected = sourceInfo.isSelected;
    }

    @Override
    public StepState getState() {
        return this.state;
    }

    @Override
    public boolean isSelected() {
        return this.isSelected;
    }

    @Override
    public boolean isMuted() {
        return this.isMuted;
    }

    @Override
    public double getDuration() {
        return this.duration;
    }

    @Override
    public double getVelocity() {
        return this.velocity;
    }

    @Override
    public double getVelocitySpread() {
        return this.velocitySpread;
    }

    @Override
    public double getReleaseVelocity() {
        return this.releaseVelocity;
    }

    @Override
    public double getPressure() {
        return this.pressure;
    }

    @Override
    public double getTimbre() {
        return this.timbre;
    }

    @Override
    public double getPan() {
        return this.pan;
    }

    @Override
    public double getTranspose() {
        return this.transpose;
    }

    @Override
    public double getGain() {
        return this.gain;
    }

    @Override
    public boolean isChanceEnabled() {
        return this.isChanceEnabled;
    }

    @Override
    public double getChance() {
        return this.chance;
    }

    @Override
    public boolean isOccurrenceEnabled() {
        return this.isOccurrenceEnabled;
    }

    @Override
    public NoteOccurrenceType getOccurrence() {
        return this.occurrence;
    }

    @Override
    public boolean isRecurrenceEnabled() {
        return this.isRecurrenceEnabled;
    }

    @Override
    public int getRecurrenceLength() {
        return this.recurrenceLength;
    }

    @Override
    public int getRecurrenceMask() {
        return this.recurrenceMask;
    }

    @Override
    public boolean isRepeatEnabled() {
        return this.isRepeatEnabled;
    }

    @Override
    public int getRepeatCount() {
        return this.repeatCount;
    }

    @Override
    public String getFormattedRepeatCount() {
        int count = this.getRepeatCount();
        if (count == 0) {
            return "Off";
        }
        if (count < 0) {
            return "1/" + Math.abs(count - 1);
        }
        return Integer.toString(count + 1);
    }

    @Override
    public double getRepeatCurve() {
        return this.repeatCurve;
    }

    @Override
    public double getRepeatVelocityCurve() {
        return this.repeatVelocityCurve;
    }

    @Override
    public double getRepeatVelocityEnd() {
        return this.repeatVelocityEnd;
    }

    @Override
    public IStepInfo createCopy() {
        return new DefaultStepInfo(this);
    }

    public void setState(StepState state) {
        this.state = state;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public void setMuted(boolean isMuted) {
        this.isMuted = isMuted;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public void setVelocity(double velocity) {
        this.velocity = velocity;
    }

    public void setVelocitySpread(double velocitySpread) {
        this.velocitySpread = velocitySpread;
    }

    public void setReleaseVelocity(double releaseVelocity) {
        this.releaseVelocity = releaseVelocity;
    }

    public void setPressure(double pressure) {
        this.pressure = pressure;
    }

    public void setTimbre(double timbre) {
        this.timbre = timbre;
    }

    public void setPan(double pan) {
        this.pan = pan;
    }

    public void setTranspose(double transpose) {
        this.transpose = transpose;
    }

    public void setGain(double gain) {
        this.gain = gain;
    }

    public void setIsChanceEnabled(boolean isEnabled) {
        this.isChanceEnabled = isEnabled;
    }

    public void setChance(double chance) {
        this.chance = chance;
    }

    public void setIsOccurrenceEnabled(boolean isEnabled) {
        this.isOccurrenceEnabled = isEnabled;
    }

    public void setOccurrence(NoteOccurrenceType occurrence) {
        this.occurrence = occurrence;
    }

    public void setIsRecurrenceEnabled(boolean isEnabled) {
        this.isRecurrenceEnabled = isEnabled;
    }

    public void setRecurrenceLength(int recurrenceLength) {
        this.recurrenceLength = recurrenceLength;
    }

    public void setRecurrenceMask(int recurrenceMask) {
        this.recurrenceMask = recurrenceMask;
    }

    public void setIsRepeatEnabled(boolean isEnabled) {
        this.isRepeatEnabled = isEnabled;
    }

    public void setRepeatCount(int repeatCount) {
        this.repeatCount = repeatCount;
    }

    public void setRepeatCurve(double repeatCurve) {
        this.repeatCurve = repeatCurve;
    }

    public void setRepeatVelocityCurve(double repeatVelocityCurve) {
        this.repeatVelocityCurve = repeatVelocityCurve;
    }

    public void setRepeatVelocityEnd(double repeatVelocityEnd) {
        this.repeatVelocityEnd = repeatVelocityEnd;
    }
}

