/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.controller.valuechanger;

import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.controller.valuechanger.OffsetBinaryRelativeValueChanger;
import de.mossgrabers.framework.controller.valuechanger.RelativeEncoding;
import de.mossgrabers.framework.controller.valuechanger.SignedBit2RelativeValueChanger;
import de.mossgrabers.framework.controller.valuechanger.SignedBitRelativeValueChanger;
import de.mossgrabers.framework.controller.valuechanger.TwosComplementValueChanger;
import java.util.EnumMap;
import java.util.Map;

public class RelativeValueChangers {
    private static final Map<RelativeEncoding, IValueChanger> VALUE_CHANGERS = new EnumMap<RelativeEncoding, IValueChanger>(RelativeEncoding.class);

    public static IValueChanger get(RelativeEncoding encoding) {
        return VALUE_CHANGERS.get((Object)encoding);
    }

    public static void setSensitivity(double sensitivity) {
        VALUE_CHANGERS.forEach((enc, valueChanger) -> valueChanger.setSensitivity(sensitivity));
    }

    private RelativeValueChangers() {
    }

    static {
        VALUE_CHANGERS.put(RelativeEncoding.TWOS_COMPLEMENT, new TwosComplementValueChanger(128, 1));
        VALUE_CHANGERS.put(RelativeEncoding.OFFSET_BINARY, new OffsetBinaryRelativeValueChanger(128, 1));
        VALUE_CHANGERS.put(RelativeEncoding.SIGNED_BIT, new SignedBitRelativeValueChanger(128, 1));
        VALUE_CHANGERS.put(RelativeEncoding.SIGNED_BIT2, new SignedBit2RelativeValueChanger(128, 1));
    }
}

