/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.controller.grid;

import de.mossgrabers.framework.utils.FrameworkException;

public final class LightInfo {
    private int color = 0;
    private int blinkColor = 0;
    private boolean fast = false;
    private int encoded = 0;

    public LightInfo() {
    }

    public LightInfo(int color, int blinkColor, boolean fast) {
        this.setColors(color, blinkColor, fast);
    }

    public void setColors(int color, int blinkColor, boolean fast) {
        if (color < 0 || color > 127) {
            throw new FrameworkException("color must be in the range of 0..127.");
        }
        if (blinkColor < -1 || blinkColor > 127) {
            throw new FrameworkException("blinkColor must be in the range of 0..127 or -1 for off.");
        }
        this.color = color;
        this.blinkColor = blinkColor;
        this.fast = fast;
        this.encode();
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
        this.encode();
    }

    public int getBlinkColor() {
        return this.blinkColor;
    }

    public void setBlinkColor(int blinkColor) {
        this.blinkColor = blinkColor;
        this.encode();
    }

    public boolean isFast() {
        return this.fast;
    }

    public void setFast(boolean fast) {
        this.fast = fast;
        this.encode();
    }

    public int getEncoded() {
        return this.encoded;
    }

    private void encode() {
        if (this.color < 0 || this.color > 127) {
            throw new FrameworkException("Color indices must be in the range of [0..127] but is " + this.color + "!");
        }
        if (this.blinkColor > 127) {
            throw new FrameworkException("Color indices may not be larger than 127 but blink index is " + this.blinkColor + "!");
        }
        int codeBlinkColor = this.blinkColor < 0 ? 32768 : this.blinkColor << 8;
        int codeFast = this.fast ? 65536 : 0;
        this.encoded = codeFast + codeBlinkColor + this.color;
    }
}

