/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.controller;

import de.mossgrabers.framework.controller.IControllerDefinition;
import de.mossgrabers.framework.usb.UsbMatcher;
import de.mossgrabers.framework.utils.OperatingSystem;
import de.mossgrabers.framework.utils.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public abstract class DefaultControllerDefinition
implements IControllerDefinition {
    private final String name;
    private final String author;
    private final UUID uuid;
    private final String hardwareModel;
    private final String hardwareVendor;
    private final int numMidiInPorts;
    private final int numMidiOutPorts;

    protected DefaultControllerDefinition(UUID uuid, String hardwareModel, String hardwareVendor, int numMidiInPorts, int numMidiOutPorts) {
        this.name = "";
        this.author = "J\u00fcrgen Mo\u00dfgraber";
        this.uuid = uuid;
        this.hardwareModel = hardwareModel;
        this.hardwareVendor = hardwareVendor;
        this.numMidiInPorts = numMidiInPorts;
        this.numMidiOutPorts = numMidiOutPorts;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public String getVersion(Package pckg) {
        return pckg == null ? "1.0" : pckg.getImplementationVersion();
    }

    @Override
    public UUID getId() {
        return this.uuid;
    }

    @Override
    public String getHardwareVendor() {
        return this.hardwareVendor;
    }

    @Override
    public String getHardwareModel() {
        return this.hardwareModel;
    }

    @Override
    public int getNumMidiInPorts() {
        return this.numMidiInPorts;
    }

    @Override
    public int getNumMidiOutPorts() {
        return this.numMidiOutPorts;
    }

    @Override
    public List<Pair<String[], String[]>> getMidiDiscoveryPairs(OperatingSystem os) {
        return new ArrayList<Pair<String[], String[]>>();
    }

    @Override
    public UsbMatcher claimUSBDevice() {
        return null;
    }

    protected List<Pair<String[], String[]>> createDeviceDiscoveryPairs(String deviceName) {
        String namePattern = "%s" + deviceName;
        List<Pair<String[], String[]>> results = this.createWindowsDeviceDiscoveryPairs(namePattern, namePattern);
        for (int i = 1; i < 20; ++i) {
            results.add(this.addDeviceDiscoveryPair(deviceName + " MIDI " + i));
            results.add(this.addDeviceDiscoveryPair(deviceName + " " + i + " MIDI 1"));
        }
        return results;
    }

    protected List<Pair<String[], String[]>> createWindowsDeviceDiscoveryPairs(String inputNamePattern, String outputNamePattern) {
        ArrayList<Pair<String[], String[]>> results = new ArrayList<Pair<String[], String[]>>();
        results.add(this.addDeviceDiscoveryPair(String.format(inputNamePattern, ""), String.format(outputNamePattern, "")));
        for (int i = 1; i < 20; ++i) {
            results.add(this.addDeviceDiscoveryPair(String.format(inputNamePattern, i + "- "), String.format(outputNamePattern, i + "- ")));
        }
        return results;
    }

    protected List<Pair<String[], String[]>> createLinuxDeviceDiscoveryPairs(String inputName, String outputName) {
        return this.createLinuxDeviceDiscoveryPairs(inputName, outputName, 0);
    }

    protected List<Pair<String[], String[]>> createLinuxDeviceDiscoveryPairs(String inputName, String outputName, int port) {
        ArrayList<Pair<String[], String[]>> results = new ArrayList<Pair<String[], String[]>>();
        results.add(this.addDeviceDiscoveryPair(inputName, outputName));
        for (int i = 1; i < 20; ++i) {
            results.add(this.addDeviceDiscoveryPair(String.format("%s [hw:%d,0,%d]", inputName, i, port), String.format("%s [hw:%d,0,%d]", outputName, i, port)));
            results.add(this.addDeviceDiscoveryPair(String.format("%s MIDI %d", inputName, i), String.format("%s MIDI %d", outputName, i)));
        }
        return results;
    }

    protected Pair<String[], String[]> addDeviceDiscoveryPair(String name) {
        return this.addDeviceDiscoveryPair(name, name);
    }

    protected Pair<String[], String[]> addDeviceDiscoveryPair(String nameIn, String nameOut) {
        String[] stringArray;
        String[] stringArray2;
        if (nameIn == null) {
            stringArray2 = new String[]{};
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = nameIn;
        }
        if (nameOut == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = nameOut;
        }
        return this.addDeviceDiscoveryPair(stringArray2, stringArray);
    }

    protected Pair<String[], String[]> addDeviceDiscoveryPair(String[] ins, String[] outs) {
        return new Pair<String[], String[]>(ins, outs);
    }

    public String toString() {
        return this.getHardwareVendor() + ' ' + this.getHardwareModel();
    }
}

