/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.transport;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.constants.AutomationMode;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;

public class AutomationModeCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    private final AutomationMode autoMode;
    private final boolean notify;

    public AutomationModeCommand(AutomationMode autoMode, IModel model, S surface, boolean notify) {
        super(model, surface);
        this.autoMode = autoMode;
        this.notify = notify;
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ITransport transport = this.model.getTransport();
        if (this.surface.isSelectPressed()) {
            transport.resetAutomationOverrides();
        } else {
            transport.setAutomationWriteMode(this.autoMode);
            if (this.notify) {
                this.surface.getDisplay().notify(StringUtils.limit(this.autoMode.name(), 4));
            }
        }
    }
}

