/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.yaeltex.turn.view;

import de.mossgrabers.controller.yaeltex.turn.YaeltexTurnConfiguration;
import de.mossgrabers.controller.yaeltex.turn.controller.YaeltexTurnControlSurface;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.view.sequencer.AbstractDrumView;

public class DrumView
extends AbstractDrumView<YaeltexTurnControlSurface, YaeltexTurnConfiguration> {
    public DrumView(YaeltexTurnControlSurface surface, IModel model) {
        super("Drum", surface, model, 4, 0, true);
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (((YaeltexTurnControlSurface)this.surface).isShiftPressed()) {
            if (velocity == 0) {
                return;
            }
            int index = note - 36;
            int x = index % this.numColumns;
            int y = 3 - index / this.numColumns;
            int steps = y * this.numColumns + x + 1;
            INoteClip clip = this.getClip();
            clip.setLoopLength((double)(steps += clip.getEditPage() * this.sequencerSteps) * Resolution.getValueAt(this.getResolutionIndex()));
            return;
        }
        super.onGridNote(note, velocity);
    }

    @Override
    public void drawGrid() {
        if (((YaeltexTurnControlSurface)this.surface).isShiftPressed()) {
            boolean isActive = this.isActive();
            INoteClip clip = this.getClip();
            int numberOfActiveSteps = (int)Math.floor(clip.getLoopLength() / Resolution.getValueAt(this.getResolutionIndex()));
            numberOfActiveSteps -= clip.getEditPage() * this.sequencerSteps;
            IPadGrid padGrid = ((YaeltexTurnControlSurface)this.surface).getPadGrid();
            for (int col = 0; col < this.sequencerSteps; ++col) {
                String color;
                int x = col % this.numColumns;
                int y = col / this.numColumns;
                if (!isActive) {
                    color = "COLOR_NO_CONTENT";
                } else {
                    boolean isFourth;
                    boolean bl = isFourth = (col + 1) % 4 == 0;
                    color = col < numberOfActiveSteps ? (isFourth ? "COLOR_ACTIVE_PAGE" : "COLOR_PAGE") : (isFourth ? "COLOR_SELECTED_PAGE" : "COLOR_NO_CONTENT");
                }
                padGrid.lightEx(x, y, color);
            }
            return;
        }
        super.drawGrid();
    }
}

