/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.osc.module;

import de.mossgrabers.controller.osc.exception.IllegalParameterException;
import de.mossgrabers.controller.osc.exception.MissingCommandException;
import de.mossgrabers.controller.osc.exception.UnknownCommandException;
import de.mossgrabers.controller.osc.module.AbstractModule;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IBrowserColumn;
import de.mossgrabers.framework.daw.data.IBrowserColumnItem;
import de.mossgrabers.framework.osc.IOpenSoundControlWriter;
import java.util.LinkedList;

public class BrowserModule
extends AbstractModule {
    public BrowserModule(IHost host, IModel model, IOpenSoundControlWriter writer) {
        super(host, model, writer);
    }

    @Override
    public String[] getSupportedCommands() {
        return new String[]{"browser"};
    }

    @Override
    public void execute(String command, LinkedList<String> path, Object value) throws IllegalParameterException, UnknownCommandException, MissingCommandException {
        if (!"browser".equals(command)) {
            throw new UnknownCommandException(command);
        }
        String subCommand = BrowserModule.getSubCommand(path);
        IBrowser browser = this.model.getBrowser();
        switch (subCommand) {
            case "preset": {
                browser.replace(this.model.getCursorDevice());
                break;
            }
            case "tab": {
                if (!browser.isActive()) {
                    return;
                }
                String subCmd = BrowserModule.getSubCommand(path);
                if ("+".equals(subCmd)) {
                    browser.nextContentType();
                    break;
                }
                if (!"-".equals(subCmd)) break;
                browser.previousContentType();
                break;
            }
            case "device": {
                String insertLocation;
                String string = insertLocation = path.isEmpty() ? null : path.removeFirst();
                if (insertLocation == null || "after".equals(insertLocation)) {
                    browser.insertAfterCursorDevice();
                    break;
                }
                browser.insertBeforeCursorDevice();
                break;
            }
            case "commit": {
                browser.stopBrowsing(true);
                break;
            }
            case "cancel": {
                browser.stopBrowsing(false);
                break;
            }
            case "filter": {
                String indexCmd = BrowserModule.getSubCommand(path);
                int column = Integer.parseInt(indexCmd);
                if (column < 1 || column > 6) {
                    return;
                }
                --column;
                if (!browser.isActive()) {
                    return;
                }
                String cmd = BrowserModule.getSubCommand(path);
                if ("+".equals(cmd)) {
                    browser.selectNextFilterItem(column);
                    break;
                }
                if ("-".equals(cmd)) {
                    browser.selectPreviousFilterItem(column);
                    break;
                }
                if (!"reset".equals(cmd)) break;
                browser.getFilterColumn(column).resetFilter();
                break;
            }
            case "result": {
                String direction;
                if (!browser.isActive()) {
                    return;
                }
                String string = direction = path.isEmpty() ? "+" : path.removeFirst();
                if ("+".equals(direction)) {
                    browser.selectNextResult();
                    break;
                }
                browser.selectPreviousResult();
                break;
            }
            default: {
                throw new UnknownCommandException(command);
            }
        }
    }

    @Override
    public void flush(boolean dump) {
        String browserAddress = "/browser/";
        IBrowser browser = this.model.getBrowser();
        boolean isActive = browser.isActive();
        this.writer.sendOSC("/browser/isActive", isActive, dump);
        if (!isActive) {
            return;
        }
        this.writer.sendOSC("/browser/tab", browser.getSelectedContentType(), dump);
        for (int i = 0; i < browser.getFilterColumnCount(); ++i) {
            String filterAddress = "/browser/filter/" + (i + 1) + "/";
            IBrowserColumn column = browser.getFilterColumn(i);
            this.writer.sendOSC(filterAddress + "exists", column.doesExist(), dump);
            this.writer.sendOSC(filterAddress + "name", column.getName(), dump);
            this.writer.sendOSC(filterAddress + "wildcard", column.getWildcard(), dump);
            IBrowserColumnItem[] items = column.getItems();
            for (int j = 0; j < items.length; ++j) {
                String browserItemAddress = filterAddress + "item/" + (j + 1) + "/";
                this.writer.sendOSC(browserItemAddress + "exists", items[j].doesExist(), dump);
                this.writer.sendOSC(browserItemAddress + "name", items[j].getName(), dump);
                this.writer.sendOSC(browserItemAddress + "hits", items[j].getHitCount(), dump);
                this.writer.sendOSC(browserItemAddress + "isSelected", items[j].isSelected(), dump);
            }
        }
        String presetAddress = "/browser/result/";
        IBrowserColumnItem[] items = browser.getResultColumnItems();
        for (int i = 0; i < items.length; ++i) {
            String browserPresetAddress = "/browser/result/" + (i + 1) + "/";
            this.writer.sendOSC(browserPresetAddress + "exists", items[i].doesExist(), dump);
            this.writer.sendOSC(browserPresetAddress + "name", items[i].getName(), dump);
            this.writer.sendOSC(browserPresetAddress + "hits", items[i].getHitCount(), dump);
            this.writer.sendOSC(browserPresetAddress + "isSelected", items[i].isSelected(), dump);
        }
    }
}

