/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.mcu.mode.track;

import de.mossgrabers.controller.mackie.mcu.MCUConfiguration;
import de.mossgrabers.controller.mackie.mcu.controller.MCUControlSurface;
import de.mossgrabers.controller.mackie.mcu.mode.track.AbstractTrackMode;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.parameterprovider.IParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.EmptyParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.RangeFilterParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.SelectedTrackParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.SendParameterProvider;
import de.mossgrabers.framework.parameterprovider.track.VolumeParameterProvider;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.Arrays;
import java.util.Optional;

public class TrackMode
extends AbstractTrackMode {
    public TrackMode(MCUControlSurface surface, IModel model) {
        super("Track", surface, model);
        int surfaceID;
        IParameterProvider parameterProvider = this.pinFXtoLastDevice ? new VolumeParameterProvider(model.getEffectTrackBank()) : ((surfaceID = surface.getSurfaceID()) == 0 ? new RangeFilterParameterProvider(new SelectedTrackParameterProvider(model), 0, 8) : (surfaceID == 1 ? new RangeFilterParameterProvider(new SendParameterProvider(model, -1, 6), 0, 8) : new EmptyParameterProvider(8)));
        this.setParameterProvider(parameterProvider);
    }

    @Override
    public void updateKnobLEDs() {
        int[] ledModes = new int[8];
        Arrays.fill(ledModes, 2);
        if (this.getExtenderOffset() == 0 && this.getParameterProvider().get(1).doesExist()) {
            ledModes[1] = 1;
        }
        this.updateKnobLEDs(ledModes);
    }

    @Override
    protected void drawTrackNameHeader() {
        this.drawParameterHeader();
        if (((MCUConfiguration)((MCUControlSurface)this.surface).getConfiguration()).getMainDisplayType() == MCUConfiguration.MainDisplay.ASPARION && ((MCUControlSurface)this.surface).getSurfaceID() == 0) {
            Optional selectedTrack = this.model.getCurrentTrackBank().getSelectedItem();
            if (selectedTrack.isEmpty()) {
                return;
            }
            ITextDisplay display = ((MCUControlSurface)this.surface).getTextDisplay();
            display.clearRow(0);
            display.setCell(0, 0, StringUtils.shortenAndFixASCII(((ITrack)selectedTrack.get()).getName(), this.getTextLength()));
            display.done(0);
        }
    }

    @Override
    protected void drawParameterHeader(ITextDisplay display, int row) {
        super.drawParameterHeader(display, row);
        if (this.getExtenderOffset() == 0 && this.configuration.isDisplayTrackNames()) {
            Optional selectedTrack = this.model.getCurrentTrackBank().getSelectedItem();
            if (selectedTrack.isEmpty()) {
                return;
            }
            display.setCell(row, 0, StringUtils.shortenAndFixASCII(((ITrack)selectedTrack.get()).getName(), this.getTextLength()));
            display.done(row);
        }
    }

    @Override
    protected void updateItemIndices() {
        ICursorTrack selectedTrack;
        int[] indices = new int[8];
        Arrays.fill(indices, 0);
        if (this.getExtenderOffset() == 0 && (selectedTrack = this.model.getCursorTrack()).doesExist()) {
            indices[0] = selectedTrack.getPosition() + 1;
        }
        ((MCUControlSurface)this.surface).setItemIndices(indices);
    }
}

