/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.mcu.mode.device;

import de.mossgrabers.controller.mackie.mcu.controller.MCUControlSurface;
import de.mossgrabers.controller.mackie.mcu.mode.BaseMode;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IBrowser;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IBrowserColumn;
import de.mossgrabers.framework.daw.data.IBrowserColumnItem;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.Optional;

public class DeviceBrowserMode
extends BaseMode<IItem> {
    private static final int SELECTION_OFF = 0;
    private static final int SELECTION_PRESET = 1;
    private static final int SELECTION_FILTER = 2;
    private static final ColorEx[] COLORS = new ColorEx[]{ColorEx.SKY_BLUE, ColorEx.SKY_BLUE, ColorEx.SKY_BLUE, ColorEx.SKY_BLUE, ColorEx.SKY_BLUE, ColorEx.SKY_BLUE, ColorEx.SKY_BLUE, ColorEx.SKY_BLUE};
    private int selectionMode = 0;
    private int filterColumn = -1;

    public DeviceBrowserMode(MCUControlSurface surface, IModel model) {
        super("Browser", surface, model);
    }

    @Override
    public void onDeactivate() {
        super.onDeactivate();
        this.model.getBrowser().stopBrowsing(true);
    }

    @Override
    public void onKnobValue(int index, int value) {
        boolean direction;
        int speed = this.model.getValueChanger().calcSteppedKnobChange(value);
        boolean bl = direction = speed > 0;
        if (((MCUControlSurface)this.surface).isShiftPressed()) {
            speed *= 4;
        }
        speed = Math.abs(speed);
        if (direction) {
            this.selectNext(index, speed);
        } else {
            this.selectPrevious(index, speed);
        }
    }

    @Override
    public void updateDisplay() {
        ((MCUControlSurface)this.surface).sendDisplayColor(COLORS);
        IBrowser browser = this.model.getBrowser();
        ITextDisplay d = ((MCUControlSurface)this.surface).getTextDisplay();
        boolean isPresetSession = browser.isPresetContentType();
        ICursorDevice cd = this.model.getCursorDevice();
        if (!(!isPresetSession || browser.isActive() && cd.doesExist())) {
            d.notify("No active Browsing Session. Select device and press Browser...");
            return;
        }
        d.clear();
        int textLength = this.getTextLength();
        switch (this.selectionMode) {
            case 0: {
                for (int i = 0; i < 7; ++i) {
                    Optional<IBrowserColumn> column = this.getFilterColumn(i);
                    String value = "";
                    String name = "";
                    if (column.isPresent()) {
                        IBrowserColumn browserColumn = column.get();
                        if (browserColumn.doesCursorExist()) {
                            value = browserColumn.getCursorName().equals(browserColumn.getWildcard()) ? "-" : browserColumn.getCursorName();
                        }
                        name = StringUtils.shortenAndFixASCII(browserColumn.getName(), textLength);
                    }
                    d.setCell(0, i, name).setCell(1, i, value);
                }
                String selectedResult = browser.getSelectedResult();
                d.setCell(0, 7, browser.getSelectedContentType()).setCell(1, 7, selectedResult == null || selectedResult.length() == 0 ? "-" : selectedResult);
                break;
            }
            case 1: {
                IBrowserColumnItem[] results = browser.getResultColumnItems();
                for (int i = 0; i < browser.getNumFilterColumnEntries() && i < results.length; ++i) {
                    d.setBlock(i / 4, i % 4, (results[i].isSelected() ? ">" : " ") + StringUtils.fixASCII(results[i].getName()));
                }
                break;
            }
            case 2: {
                IBrowserColumnItem[] items = browser.getFilterColumn(this.filterColumn).getItems();
                for (int i = 0; i < browser.getNumResults(); ++i) {
                    d.setBlock(i / 4, i % 4, (items[i].isSelected() ? ">" : " ") + StringUtils.fixASCII(items[i].getName()));
                }
                break;
            }
        }
        d.allDone();
    }

    @Override
    protected void resetParameter(int index) {
        if (this.selectionMode != 0) {
            this.selectionMode = 0;
            return;
        }
        if (index == 7) {
            this.selectionMode = 1;
            this.filterColumn = -1;
        } else {
            Optional<IBrowserColumn> fc = this.getFilterColumn(index);
            if (fc.isPresent() && fc.get().doesExist()) {
                this.selectionMode = 2;
                this.filterColumn = fc.get().getIndex();
            }
        }
    }

    @Override
    public void updateKnobLEDs() {
        for (int i = 0; i < 8; ++i) {
            ((MCUControlSurface)this.surface).setKnobLED(i, 2, 0, 1);
        }
    }

    private Optional<IBrowserColumn> getFilterColumn(int index) {
        IBrowser browser = this.model.getBrowser();
        int column = -1;
        for (int i = 0; i < browser.getFilterColumnCount(); ++i) {
            if (++column != index) continue;
            return Optional.of(browser.getFilterColumn(i));
        }
        return Optional.empty();
    }

    private void selectNext(int index, int count) {
        block3: {
            IBrowser browser;
            block2: {
                browser = this.model.getBrowser();
                if (index >= 7) break block2;
                Optional<IBrowserColumn> fc = this.getFilterColumn(index);
                if (!fc.isPresent() || !fc.get().doesExist()) break block3;
                this.filterColumn = fc.get().getIndex();
                for (int i = 0; i < count; ++i) {
                    browser.selectNextFilterItem(this.filterColumn);
                }
                if (browser.getSelectedFilterItemIndex(this.filterColumn) != -1) break block3;
                browser.nextFilterItemPage(this.filterColumn);
                break block3;
            }
            for (int i = 0; i < count; ++i) {
                browser.selectNextResult();
            }
        }
    }

    private void selectPrevious(int index, int count) {
        IBrowser browser = this.model.getBrowser();
        for (int i = 0; i < count; ++i) {
            if (index < 7) {
                Optional<IBrowserColumn> fc = this.getFilterColumn(index);
                if (!fc.isPresent() || !fc.get().doesExist()) continue;
                this.filterColumn = fc.get().getIndex();
                for (int j = 0; j < count; ++j) {
                    browser.selectPreviousFilterItem(this.filterColumn);
                }
                if (browser.getSelectedFilterItemIndex(this.filterColumn) != -1) continue;
                browser.previousFilterItemPage(this.filterColumn);
                continue;
            }
            for (int j = 0; j < count; ++j) {
                browser.selectPreviousResult();
            }
        }
    }
}

