/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.generic.flexihandler;

import de.mossgrabers.controller.generic.GenericFlexiConfiguration;
import de.mossgrabers.controller.generic.controller.FlexiCommand;
import de.mossgrabers.controller.generic.controller.GenericFlexiControlSurface;
import de.mossgrabers.controller.generic.flexihandler.AbstractHandler;
import de.mossgrabers.controller.generic.flexihandler.utils.FlexiHandlerException;
import de.mossgrabers.controller.generic.flexihandler.utils.KnobMode;
import de.mossgrabers.controller.generic.flexihandler.utils.MidiValue;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IMarker;
import de.mossgrabers.framework.daw.data.bank.IMarkerBank;

public class MarkerHandler
extends AbstractHandler {
    public MarkerHandler(IModel model, GenericFlexiControlSurface surface, GenericFlexiConfiguration configuration, IValueChanger absoluteLowResValueChanger, IValueChanger signedBitRelativeValueChanger, IValueChanger signedBit2RelativeValueChanger, IValueChanger offsetBinaryRelativeValueChanger) {
        super(model, surface, configuration, absoluteLowResValueChanger, signedBitRelativeValueChanger, signedBit2RelativeValueChanger, offsetBinaryRelativeValueChanger);
    }

    @Override
    public FlexiCommand[] getSupportedCommands() {
        return new FlexiCommand[]{FlexiCommand.MARKER_1_LAUNCH_MARKER, FlexiCommand.MARKER_2_LAUNCH_MARKER, FlexiCommand.MARKER_3_LAUNCH_MARKER, FlexiCommand.MARKER_4_LAUNCH_MARKER, FlexiCommand.MARKER_5_LAUNCH_MARKER, FlexiCommand.MARKER_6_LAUNCH_MARKER, FlexiCommand.MARKER_7_LAUNCH_MARKER, FlexiCommand.MARKER_8_LAUNCH_MARKER, FlexiCommand.MARKER_SELECT_PREVIOUS_BANK, FlexiCommand.MARKER_SELECT_NEXT_BANK};
    }

    @Override
    public int getCommandValue(FlexiCommand command) {
        return -1;
    }

    @Override
    public void handle(FlexiCommand command, KnobMode knobMode, MidiValue value) {
        if (!this.isButtonPressed(knobMode, value)) {
            return;
        }
        IMarkerBank markerBank = this.model.getMarkerBank();
        switch (command) {
            case MARKER_1_LAUNCH_MARKER: 
            case MARKER_2_LAUNCH_MARKER: 
            case MARKER_3_LAUNCH_MARKER: 
            case MARKER_4_LAUNCH_MARKER: 
            case MARKER_5_LAUNCH_MARKER: 
            case MARKER_6_LAUNCH_MARKER: 
            case MARKER_7_LAUNCH_MARKER: 
            case MARKER_8_LAUNCH_MARKER: {
                int index = command.ordinal() - FlexiCommand.MARKER_1_LAUNCH_MARKER.ordinal();
                ((IMarker)markerBank.getItem(index)).launch(true);
                break;
            }
            case MARKER_SELECT_PREVIOUS_BANK: {
                markerBank.selectPreviousPage();
                break;
            }
            case MARKER_SELECT_NEXT_BANK: {
                markerBank.selectNextPage();
                break;
            }
            default: {
                throw new FlexiHandlerException(command);
            }
        }
    }
}

